/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class MigrateToDataTiersResponse
implements JsonpSerializable {
    private final boolean dryRun;
    private final String removedLegacyTemplate;
    private final List<String> migratedIlmPolicies;
    private final List<String> migratedIndices;
    private final List<String> migratedLegacyTemplates;
    private final List<String> migratedComposableTemplates;
    private final List<String> migratedComponentTemplates;
    public static final JsonpDeserializer<MigrateToDataTiersResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MigrateToDataTiersResponse::setupMigrateToDataTiersResponseDeserializer);

    private MigrateToDataTiersResponse(Builder builder) {
        this.dryRun = ApiTypeHelper.requireNonNull(builder.dryRun, this, "dryRun");
        this.removedLegacyTemplate = ApiTypeHelper.requireNonNull(builder.removedLegacyTemplate, this, "removedLegacyTemplate");
        this.migratedIlmPolicies = ApiTypeHelper.unmodifiableRequired(builder.migratedIlmPolicies, (Object)this, "migratedIlmPolicies");
        this.migratedIndices = ApiTypeHelper.unmodifiableRequired(builder.migratedIndices, (Object)this, "migratedIndices");
        this.migratedLegacyTemplates = ApiTypeHelper.unmodifiableRequired(builder.migratedLegacyTemplates, (Object)this, "migratedLegacyTemplates");
        this.migratedComposableTemplates = ApiTypeHelper.unmodifiableRequired(builder.migratedComposableTemplates, (Object)this, "migratedComposableTemplates");
        this.migratedComponentTemplates = ApiTypeHelper.unmodifiableRequired(builder.migratedComponentTemplates, (Object)this, "migratedComponentTemplates");
    }

    public static MigrateToDataTiersResponse of(Function<Builder, ObjectBuilder<MigrateToDataTiersResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean dryRun() {
        return this.dryRun;
    }

    public final String removedLegacyTemplate() {
        return this.removedLegacyTemplate;
    }

    public final List<String> migratedIlmPolicies() {
        return this.migratedIlmPolicies;
    }

    public final List<String> migratedIndices() {
        return this.migratedIndices;
    }

    public final List<String> migratedLegacyTemplates() {
        return this.migratedLegacyTemplates;
    }

    public final List<String> migratedComposableTemplates() {
        return this.migratedComposableTemplates;
    }

    public final List<String> migratedComponentTemplates() {
        return this.migratedComponentTemplates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("dry_run");
        generator.write(this.dryRun);
        generator.writeKey("removed_legacy_template");
        generator.write(this.removedLegacyTemplate);
        if (ApiTypeHelper.isDefined(this.migratedIlmPolicies)) {
            generator.writeKey("migrated_ilm_policies");
            generator.writeStartArray();
            for (String item0 : this.migratedIlmPolicies) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.migratedIndices)) {
            generator.writeKey("migrated_indices");
            generator.writeStartArray();
            for (String item0 : this.migratedIndices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.migratedLegacyTemplates)) {
            generator.writeKey("migrated_legacy_templates");
            generator.writeStartArray();
            for (String item0 : this.migratedLegacyTemplates) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.migratedComposableTemplates)) {
            generator.writeKey("migrated_composable_templates");
            generator.writeStartArray();
            for (String item0 : this.migratedComposableTemplates) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.migratedComponentTemplates)) {
            generator.writeKey("migrated_component_templates");
            generator.writeStartArray();
            for (String item0 : this.migratedComponentTemplates) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMigrateToDataTiersResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dryRun, JsonpDeserializer.booleanDeserializer(), "dry_run");
        op.add(Builder::removedLegacyTemplate, JsonpDeserializer.stringDeserializer(), "removed_legacy_template");
        op.add(Builder::migratedIlmPolicies, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "migrated_ilm_policies");
        op.add(Builder::migratedIndices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "migrated_indices");
        op.add(Builder::migratedLegacyTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "migrated_legacy_templates");
        op.add(Builder::migratedComposableTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "migrated_composable_templates");
        op.add(Builder::migratedComponentTemplates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "migrated_component_templates");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MigrateToDataTiersResponse> {
        private Boolean dryRun;
        private String removedLegacyTemplate;
        private List<String> migratedIlmPolicies;
        private List<String> migratedIndices;
        private List<String> migratedLegacyTemplates;
        private List<String> migratedComposableTemplates;
        private List<String> migratedComponentTemplates;

        public final Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        public final Builder removedLegacyTemplate(String value) {
            this.removedLegacyTemplate = value;
            return this;
        }

        public final Builder migratedIlmPolicies(List<String> list) {
            this.migratedIlmPolicies = Builder._listAddAll(this.migratedIlmPolicies, list);
            return this;
        }

        public final Builder migratedIlmPolicies(String value, String ... values) {
            this.migratedIlmPolicies = Builder._listAdd(this.migratedIlmPolicies, value, values);
            return this;
        }

        public final Builder migratedIndices(List<String> list) {
            this.migratedIndices = Builder._listAddAll(this.migratedIndices, list);
            return this;
        }

        public final Builder migratedIndices(String value, String ... values) {
            this.migratedIndices = Builder._listAdd(this.migratedIndices, value, values);
            return this;
        }

        public final Builder migratedLegacyTemplates(List<String> list) {
            this.migratedLegacyTemplates = Builder._listAddAll(this.migratedLegacyTemplates, list);
            return this;
        }

        public final Builder migratedLegacyTemplates(String value, String ... values) {
            this.migratedLegacyTemplates = Builder._listAdd(this.migratedLegacyTemplates, value, values);
            return this;
        }

        public final Builder migratedComposableTemplates(List<String> list) {
            this.migratedComposableTemplates = Builder._listAddAll(this.migratedComposableTemplates, list);
            return this;
        }

        public final Builder migratedComposableTemplates(String value, String ... values) {
            this.migratedComposableTemplates = Builder._listAdd(this.migratedComposableTemplates, value, values);
            return this;
        }

        public final Builder migratedComponentTemplates(List<String> list) {
            this.migratedComponentTemplates = Builder._listAddAll(this.migratedComponentTemplates, list);
            return this;
        }

        public final Builder migratedComponentTemplates(String value, String ... values) {
            this.migratedComponentTemplates = Builder._listAdd(this.migratedComponentTemplates, value, values);
            return this;
        }

        @Override
        public MigrateToDataTiersResponse build() {
            this._checkSingleUse();
            return new MigrateToDataTiersResponse(this);
        }
    }
}

