/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.ThreadType;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.nodes.HotThreadsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class HotThreadsRequest
extends RequestBase {
    @Nullable
    private final Boolean ignoreIdleThreads;
    @Nullable
    private final Time interval;
    @Nullable
    private final Time masterTimeout;
    private final List<String> nodeId;
    @Nullable
    private final Long snapshots;
    @Nullable
    private final ThreadType sort;
    @Nullable
    private final Long threads;
    @Nullable
    private final Time timeout;
    @Nullable
    private final ThreadType type;
    public static final Endpoint<HotThreadsRequest, HotThreadsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<HotThreadsRequest, HotThreadsResponse>("es/nodes.hot_threads", request -> "GET", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/hot_threads");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/hot_threads");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.snapshots != null) {
            params.put("snapshots", String.valueOf(request.snapshots));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.threads != null) {
            params.put("threads", String.valueOf(request.threads));
        }
        if (request.interval != null) {
            params.put("interval", request.interval._toJsonString());
        }
        if (request.sort != null) {
            params.put("sort", request.sort.jsonValue());
        }
        if (request.type != null) {
            params.put("type", request.type.jsonValue());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.ignoreIdleThreads != null) {
            params.put("ignore_idle_threads", String.valueOf(request.ignoreIdleThreads));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, HotThreadsResponse._DESERIALIZER);

    private HotThreadsRequest(Builder builder) {
        this.ignoreIdleThreads = builder.ignoreIdleThreads;
        this.interval = builder.interval;
        this.masterTimeout = builder.masterTimeout;
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.snapshots = builder.snapshots;
        this.sort = builder.sort;
        this.threads = builder.threads;
        this.timeout = builder.timeout;
        this.type = builder.type;
    }

    public static HotThreadsRequest of(Function<Builder, ObjectBuilder<HotThreadsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean ignoreIdleThreads() {
        return this.ignoreIdleThreads;
    }

    @Nullable
    public final Time interval() {
        return this.interval;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Long snapshots() {
        return this.snapshots;
    }

    @Nullable
    public final ThreadType sort() {
        return this.sort;
    }

    @Nullable
    public final Long threads() {
        return this.threads;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final ThreadType type() {
        return this.type;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<HotThreadsRequest> {
        @Nullable
        private Boolean ignoreIdleThreads;
        @Nullable
        private Time interval;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<String> nodeId;
        @Nullable
        private Long snapshots;
        @Nullable
        private ThreadType sort;
        @Nullable
        private Long threads;
        @Nullable
        private Time timeout;
        @Nullable
        private ThreadType type;

        public final Builder ignoreIdleThreads(@Nullable Boolean value) {
            this.ignoreIdleThreads = value;
            return this;
        }

        public final Builder interval(@Nullable Time value) {
            this.interval = value;
            return this;
        }

        public final Builder interval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.interval(fn.apply(new Time.Builder()).build());
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        public final Builder snapshots(@Nullable Long value) {
            this.snapshots = value;
            return this;
        }

        public final Builder sort(@Nullable ThreadType value) {
            this.sort = value;
            return this;
        }

        public final Builder threads(@Nullable Long value) {
            this.threads = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder type(@Nullable ThreadType value) {
            this.type = value;
            return this;
        }

        @Override
        public HotThreadsRequest build() {
            this._checkSingleUse();
            return new HotThreadsRequest(this);
        }
    }
}

