/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.elasticsearch.indices.analyze.AnalyzerDetail;
import co.elastic.clients.elasticsearch.indices.analyze.CharFilterDetail;
import co.elastic.clients.elasticsearch.indices.analyze.TokenDetail;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AnalyzeDetail
implements JsonpSerializable {
    @Nullable
    private final AnalyzerDetail analyzer;
    private final List<CharFilterDetail> charfilters;
    private final boolean customAnalyzer;
    private final List<TokenDetail> tokenfilters;
    @Nullable
    private final TokenDetail tokenizer;
    public static final JsonpDeserializer<AnalyzeDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeDetail::setupAnalyzeDetailDeserializer);

    private AnalyzeDetail(Builder builder) {
        this.analyzer = builder.analyzer;
        this.charfilters = ApiTypeHelper.unmodifiable(builder.charfilters);
        this.customAnalyzer = ApiTypeHelper.requireNonNull(builder.customAnalyzer, this, "customAnalyzer");
        this.tokenfilters = ApiTypeHelper.unmodifiable(builder.tokenfilters);
        this.tokenizer = builder.tokenizer;
    }

    public static AnalyzeDetail of(Function<Builder, ObjectBuilder<AnalyzeDetail>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AnalyzerDetail analyzer() {
        return this.analyzer;
    }

    public final List<CharFilterDetail> charfilters() {
        return this.charfilters;
    }

    public final boolean customAnalyzer() {
        return this.customAnalyzer;
    }

    public final List<TokenDetail> tokenfilters() {
        return this.tokenfilters;
    }

    @Nullable
    public final TokenDetail tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            this.analyzer.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.charfilters)) {
            generator.writeKey("charfilters");
            generator.writeStartArray();
            for (CharFilterDetail charFilterDetail : this.charfilters) {
                charFilterDetail.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("custom_analyzer");
        generator.write(this.customAnalyzer);
        if (ApiTypeHelper.isDefined(this.tokenfilters)) {
            generator.writeKey("tokenfilters");
            generator.writeStartArray();
            for (TokenDetail tokenDetail : this.tokenfilters) {
                tokenDetail.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            this.tokenizer.serialize(generator, mapper);
        }
    }

    protected static void setupAnalyzeDetailDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, AnalyzerDetail._DESERIALIZER, "analyzer");
        op.add(Builder::charfilters, JsonpDeserializer.arrayDeserializer(CharFilterDetail._DESERIALIZER), "charfilters");
        op.add(Builder::customAnalyzer, JsonpDeserializer.booleanDeserializer(), "custom_analyzer");
        op.add(Builder::tokenfilters, JsonpDeserializer.arrayDeserializer(TokenDetail._DESERIALIZER), "tokenfilters");
        op.add(Builder::tokenizer, TokenDetail._DESERIALIZER, "tokenizer");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<AnalyzeDetail> {
        @Nullable
        private AnalyzerDetail analyzer;
        @Nullable
        private List<CharFilterDetail> charfilters;
        private Boolean customAnalyzer;
        @Nullable
        private List<TokenDetail> tokenfilters;
        @Nullable
        private TokenDetail tokenizer;

        public final Builder analyzer(@Nullable AnalyzerDetail value) {
            this.analyzer = value;
            return this;
        }

        public final Builder analyzer(Function<AnalyzerDetail.Builder, ObjectBuilder<AnalyzerDetail>> fn) {
            return this.analyzer(fn.apply(new AnalyzerDetail.Builder()).build());
        }

        public final Builder charfilters(List<CharFilterDetail> list) {
            this.charfilters = Builder._listAddAll(this.charfilters, list);
            return this;
        }

        public final Builder charfilters(CharFilterDetail value, CharFilterDetail ... values) {
            this.charfilters = Builder._listAdd(this.charfilters, value, values);
            return this;
        }

        public final Builder charfilters(Function<CharFilterDetail.Builder, ObjectBuilder<CharFilterDetail>> fn) {
            return this.charfilters(fn.apply(new CharFilterDetail.Builder()).build(), new CharFilterDetail[0]);
        }

        public final Builder customAnalyzer(boolean value) {
            this.customAnalyzer = value;
            return this;
        }

        public final Builder tokenfilters(List<TokenDetail> list) {
            this.tokenfilters = Builder._listAddAll(this.tokenfilters, list);
            return this;
        }

        public final Builder tokenfilters(TokenDetail value, TokenDetail ... values) {
            this.tokenfilters = Builder._listAdd(this.tokenfilters, value, values);
            return this;
        }

        public final Builder tokenfilters(Function<TokenDetail.Builder, ObjectBuilder<TokenDetail>> fn) {
            return this.tokenfilters(fn.apply(new TokenDetail.Builder()).build(), new TokenDetail[0]);
        }

        public final Builder tokenizer(@Nullable TokenDetail value) {
            this.tokenizer = value;
            return this;
        }

        public final Builder tokenizer(Function<TokenDetail.Builder, ObjectBuilder<TokenDetail>> fn) {
            return this.tokenizer(fn.apply(new TokenDetail.Builder()).build());
        }

        @Override
        public AnalyzeDetail build() {
            this._checkSingleUse();
            return new AnalyzeDetail(this);
        }
    }
}

