/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.bulk;

import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperationBase;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperationVariant;
import co.elastic.clients.elasticsearch.core.bulk.UpdateAction;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.NdJsonpSerializable;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;

public class UpdateOperation<TDocument, TPartialDocument>
extends BulkOperationBase
implements NdJsonpSerializable,
BulkOperationVariant {
    private final UpdateAction<TDocument, TPartialDocument> action;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final Integer retryOnConflict;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    @Nullable
    private final JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;

    private UpdateOperation(Builder<TDocument, TPartialDocument> builder) {
        super(builder);
        this.action = ApiTypeHelper.requireNonNull(((Builder)builder).action, this, "action");
        this.requireAlias = ((Builder)builder).requireAlias;
        this.retryOnConflict = ((Builder)builder).retryOnConflict;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
        this.tPartialDocumentSerializer = ((Builder)builder).tPartialDocumentSerializer;
    }

    public static <TDocument, TPartialDocument> UpdateOperation<TDocument, TPartialDocument> of(Function<Builder<TDocument, TPartialDocument>, ObjectBuilder<UpdateOperation<TDocument, TPartialDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public BulkOperation.Kind _bulkOperationKind() {
        return BulkOperation.Kind.Update;
    }

    public final UpdateAction<TDocument, TPartialDocument> action() {
        return this.action;
    }

    @Override
    public Iterator<?> _serializables() {
        return Arrays.asList(this, this.action).iterator();
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public final Integer retryOnConflict() {
        return this.retryOnConflict;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.requireAlias != null) {
            generator.writeKey("require_alias");
            generator.write(this.requireAlias.booleanValue());
        }
        if (this.retryOnConflict != null) {
            generator.writeKey("retry_on_conflict");
            generator.write(this.retryOnConflict.intValue());
        }
    }

    public static class Builder<TDocument, TPartialDocument>
    extends BulkOperationBase.AbstractBuilder<Builder<TDocument, TPartialDocument>>
    implements ObjectBuilder<UpdateOperation<TDocument, TPartialDocument>> {
        private UpdateAction<TDocument, TPartialDocument> action;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private Integer retryOnConflict;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;
        @Nullable
        private JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;

        public final Builder<TDocument, TPartialDocument> action(UpdateAction<TDocument, TPartialDocument> value) {
            this.action = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> action(Function<UpdateAction.Builder<TDocument, TPartialDocument>, ObjectBuilder<UpdateAction<TDocument, TPartialDocument>>> fn) {
            return this.action(fn.apply(new UpdateAction.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> retryOnConflict(@Nullable Integer value) {
            this.retryOnConflict = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> tPartialDocumentSerializer(@Nullable JsonpSerializer<TPartialDocument> value) {
            this.tPartialDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument, TPartialDocument> self() {
            return this;
        }

        @Override
        public UpdateOperation<TDocument, TPartialDocument> build() {
            this._checkSingleUse();
            return new UpdateOperation(this);
        }
    }
}

