/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ScheduleTriggerEvent;
import co.elastic.clients.elasticsearch.watcher.TriggerEventVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TriggerEvent
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<TriggerEvent> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TriggerEvent::setupTriggerEventDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public TriggerEvent(TriggerEventVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._triggerEventKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private TriggerEvent(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static TriggerEvent of(Function<Builder, ObjectBuilder<TriggerEvent>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isSchedule() {
        return this._kind == Kind.Schedule;
    }

    public ScheduleTriggerEvent schedule() {
        return (ScheduleTriggerEvent)TaggedUnionUtils.get(this, Kind.Schedule);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupTriggerEventDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::schedule, ScheduleTriggerEvent._DESERIALIZER, "schedule");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TriggerEvent> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<TriggerEvent> schedule(ScheduleTriggerEvent v) {
            this._kind = Kind.Schedule;
            this._value = v;
            return this;
        }

        public ObjectBuilder<TriggerEvent> schedule(Function<ScheduleTriggerEvent.Builder, ObjectBuilder<ScheduleTriggerEvent>> fn) {
            return this.schedule(fn.apply(new ScheduleTriggerEvent.Builder()).build());
        }

        @Override
        public TriggerEvent build() {
            this._checkSingleUse();
            return new TriggerEvent(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Schedule("schedule");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

