/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch.transform.PivotGroupBy;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Pivot
implements JsonpSerializable {
    private final Map<String, Aggregation> aggregations;
    private final Map<String, PivotGroupBy> groupBy;
    @Nullable
    private final Integer maxPageSearchSize;
    public static final JsonpDeserializer<Pivot> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pivot::setupPivotDeserializer);

    private Pivot(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.groupBy = ApiTypeHelper.unmodifiable(builder.groupBy);
        this.maxPageSearchSize = builder.maxPageSearchSize;
    }

    public static Pivot of(Function<Builder, ObjectBuilder<Pivot>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    public final Map<String, PivotGroupBy> groupBy() {
        return this.groupBy;
    }

    @Nullable
    public final Integer maxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.groupBy)) {
            generator.writeKey("group_by");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.groupBy.entrySet()) {
                generator.writeKey(entry.getKey());
                ((PivotGroupBy)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxPageSearchSize != null) {
            generator.writeKey("max_page_search_size");
            generator.write(this.maxPageSearchSize.intValue());
        }
    }

    protected static void setupPivotDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::groupBy, JsonpDeserializer.stringMapDeserializer(PivotGroupBy._DESERIALIZER), "group_by");
        op.add(Builder::maxPageSearchSize, JsonpDeserializer.integerDeserializer(), "max_page_search_size");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Pivot> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Map<String, PivotGroupBy> groupBy;
        @Nullable
        private Integer maxPageSearchSize;

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder groupBy(Map<String, PivotGroupBy> map) {
            this.groupBy = Builder._mapPutAll(this.groupBy, map);
            return this;
        }

        public final Builder groupBy(String key, PivotGroupBy value) {
            this.groupBy = Builder._mapPut(this.groupBy, key, value);
            return this;
        }

        public final Builder groupBy(String key, Function<PivotGroupBy.Builder, ObjectBuilder<PivotGroupBy>> fn) {
            return this.groupBy(key, fn.apply(new PivotGroupBy.Builder()).build());
        }

        public final Builder maxPageSearchSize(@Nullable Integer value) {
            this.maxPageSearchSize = value;
            return this;
        }

        @Override
        public Pivot build() {
            this._checkSingleUse();
            return new Pivot(this);
        }
    }
}

