/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.FieldSecurity;
import co.elastic.clients.elasticsearch.security.IndexPrivilege;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndicesPrivileges
implements JsonpSerializable {
    private final List<FieldSecurity> fieldSecurity;
    private final List<String> names;
    private final List<IndexPrivilege> privileges;
    private final List<String> query;
    @Nullable
    private final Boolean allowRestrictedIndices;
    public static final JsonpDeserializer<IndicesPrivileges> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesPrivileges::setupIndicesPrivilegesDeserializer);

    private IndicesPrivileges(Builder builder) {
        this.fieldSecurity = ApiTypeHelper.unmodifiable(builder.fieldSecurity);
        this.names = ApiTypeHelper.unmodifiableRequired(builder.names, (Object)this, "names");
        this.privileges = ApiTypeHelper.unmodifiableRequired(builder.privileges, (Object)this, "privileges");
        this.query = ApiTypeHelper.unmodifiable(builder.query);
        this.allowRestrictedIndices = builder.allowRestrictedIndices;
    }

    public static IndicesPrivileges of(Function<Builder, ObjectBuilder<IndicesPrivileges>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FieldSecurity> fieldSecurity() {
        return this.fieldSecurity;
    }

    public final List<String> names() {
        return this.names;
    }

    public final List<IndexPrivilege> privileges() {
        return this.privileges;
    }

    public final List<String> query() {
        return this.query;
    }

    @Nullable
    public final Boolean allowRestrictedIndices() {
        return this.allowRestrictedIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fieldSecurity)) {
            generator.writeKey("field_security");
            generator.writeStartArray();
            for (FieldSecurity fieldSecurity : this.fieldSecurity) {
                fieldSecurity.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.names)) {
            generator.writeKey("names");
            generator.writeStartArray();
            for (String string : this.names) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.privileges)) {
            generator.writeKey("privileges");
            generator.writeStartArray();
            for (IndexPrivilege indexPrivilege : this.privileges) {
                indexPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.query)) {
            generator.writeKey("query");
            generator.writeStartArray();
            for (String string : this.query) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.allowRestrictedIndices != null) {
            generator.writeKey("allow_restricted_indices");
            generator.write(this.allowRestrictedIndices.booleanValue());
        }
    }

    protected static void setupIndicesPrivilegesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldSecurity, JsonpDeserializer.arrayDeserializer(FieldSecurity._DESERIALIZER), "field_security");
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "names");
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(IndexPrivilege._DESERIALIZER), "privileges");
        op.add(Builder::query, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "query");
        op.add(Builder::allowRestrictedIndices, JsonpDeserializer.booleanDeserializer(), "allow_restricted_indices");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndicesPrivileges> {
        @Nullable
        private List<FieldSecurity> fieldSecurity;
        private List<String> names;
        private List<IndexPrivilege> privileges;
        @Nullable
        private List<String> query;
        @Nullable
        private Boolean allowRestrictedIndices;

        public final Builder fieldSecurity(List<FieldSecurity> list) {
            this.fieldSecurity = Builder._listAddAll(this.fieldSecurity, list);
            return this;
        }

        public final Builder fieldSecurity(FieldSecurity value, FieldSecurity ... values) {
            this.fieldSecurity = Builder._listAdd(this.fieldSecurity, value, values);
            return this;
        }

        public final Builder fieldSecurity(Function<FieldSecurity.Builder, ObjectBuilder<FieldSecurity>> fn) {
            return this.fieldSecurity(fn.apply(new FieldSecurity.Builder()).build(), new FieldSecurity[0]);
        }

        public final Builder names(List<String> list) {
            this.names = Builder._listAddAll(this.names, list);
            return this;
        }

        public final Builder names(String value, String ... values) {
            this.names = Builder._listAdd(this.names, value, values);
            return this;
        }

        public final Builder privileges(List<IndexPrivilege> list) {
            this.privileges = Builder._listAddAll(this.privileges, list);
            return this;
        }

        public final Builder privileges(IndexPrivilege value, IndexPrivilege ... values) {
            this.privileges = Builder._listAdd(this.privileges, value, values);
            return this;
        }

        public final Builder query(List<String> list) {
            this.query = Builder._listAddAll(this.query, list);
            return this;
        }

        public final Builder query(String value, String ... values) {
            this.query = Builder._listAdd(this.query, value, values);
            return this;
        }

        public final Builder allowRestrictedIndices(@Nullable Boolean value) {
            this.allowRestrictedIndices = value;
            return this;
        }

        @Override
        public IndicesPrivileges build() {
            this._checkSingleUse();
            return new IndicesPrivileges(this);
        }
    }
}

