/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TopClassEntry
implements JsonpSerializable {
    private final String className;
    private final double classProbability;
    private final double classScore;
    public static final JsonpDeserializer<TopClassEntry> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopClassEntry::setupTopClassEntryDeserializer);

    private TopClassEntry(Builder builder) {
        this.className = ApiTypeHelper.requireNonNull(builder.className, this, "className");
        this.classProbability = ApiTypeHelper.requireNonNull(builder.classProbability, this, "classProbability");
        this.classScore = ApiTypeHelper.requireNonNull(builder.classScore, this, "classScore");
    }

    public static TopClassEntry of(Function<Builder, ObjectBuilder<TopClassEntry>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String className() {
        return this.className;
    }

    public final double classProbability() {
        return this.classProbability;
    }

    public final double classScore() {
        return this.classScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("class_name");
        generator.write(this.className);
        generator.writeKey("class_probability");
        generator.write(this.classProbability);
        generator.writeKey("class_score");
        generator.write(this.classScore);
    }

    protected static void setupTopClassEntryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::className, JsonpDeserializer.stringDeserializer(), "class_name");
        op.add(Builder::classProbability, JsonpDeserializer.doubleDeserializer(), "class_probability");
        op.add(Builder::classScore, JsonpDeserializer.doubleDeserializer(), "class_score");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TopClassEntry> {
        private String className;
        private Double classProbability;
        private Double classScore;

        public final Builder className(String value) {
            this.className = value;
            return this;
        }

        public final Builder classProbability(double value) {
            this.classProbability = value;
            return this;
        }

        public final Builder classScore(double value) {
            this.classScore = value;
            return this;
        }

        @Override
        public TopClassEntry build() {
            this._checkSingleUse();
            return new TopClassEntry(this);
        }
    }
}

