/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DatafeedTimingStats
implements JsonpSerializable {
    private final long bucketCount;
    private final double exponentialAverageSearchTimePerHourMs;
    private final String jobId;
    private final long searchCount;
    private final double totalSearchTimeMs;
    private final Number averageSearchTimePerBucketMs;
    public static final JsonpDeserializer<DatafeedTimingStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatafeedTimingStats::setupDatafeedTimingStatsDeserializer);

    private DatafeedTimingStats(Builder builder) {
        this.bucketCount = ApiTypeHelper.requireNonNull(builder.bucketCount, this, "bucketCount");
        this.exponentialAverageSearchTimePerHourMs = ApiTypeHelper.requireNonNull(builder.exponentialAverageSearchTimePerHourMs, this, "exponentialAverageSearchTimePerHourMs");
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.searchCount = ApiTypeHelper.requireNonNull(builder.searchCount, this, "searchCount");
        this.totalSearchTimeMs = ApiTypeHelper.requireNonNull(builder.totalSearchTimeMs, this, "totalSearchTimeMs");
        this.averageSearchTimePerBucketMs = ApiTypeHelper.requireNonNull(builder.averageSearchTimePerBucketMs, this, "averageSearchTimePerBucketMs");
    }

    public static DatafeedTimingStats of(Function<Builder, ObjectBuilder<DatafeedTimingStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long bucketCount() {
        return this.bucketCount;
    }

    public final double exponentialAverageSearchTimePerHourMs() {
        return this.exponentialAverageSearchTimePerHourMs;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final long searchCount() {
        return this.searchCount;
    }

    public final double totalSearchTimeMs() {
        return this.totalSearchTimeMs;
    }

    public final Number averageSearchTimePerBucketMs() {
        return this.averageSearchTimePerBucketMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_count");
        generator.write(this.bucketCount);
        generator.writeKey("exponential_average_search_time_per_hour_ms");
        generator.write(this.exponentialAverageSearchTimePerHourMs);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("search_count");
        generator.write(this.searchCount);
        generator.writeKey("total_search_time_ms");
        generator.write(this.totalSearchTimeMs);
        generator.writeKey("average_search_time_per_bucket_ms");
        generator.write(this.averageSearchTimePerBucketMs.doubleValue());
    }

    protected static void setupDatafeedTimingStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bucketCount, JsonpDeserializer.longDeserializer(), "bucket_count");
        op.add(Builder::exponentialAverageSearchTimePerHourMs, JsonpDeserializer.doubleDeserializer(), "exponential_average_search_time_per_hour_ms");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::searchCount, JsonpDeserializer.longDeserializer(), "search_count");
        op.add(Builder::totalSearchTimeMs, JsonpDeserializer.doubleDeserializer(), "total_search_time_ms");
        op.add(Builder::averageSearchTimePerBucketMs, JsonpDeserializer.numberDeserializer(), "average_search_time_per_bucket_ms");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DatafeedTimingStats> {
        private Long bucketCount;
        private Double exponentialAverageSearchTimePerHourMs;
        private String jobId;
        private Long searchCount;
        private Double totalSearchTimeMs;
        private Number averageSearchTimePerBucketMs;

        public final Builder bucketCount(long value) {
            this.bucketCount = value;
            return this;
        }

        public final Builder exponentialAverageSearchTimePerHourMs(double value) {
            this.exponentialAverageSearchTimePerHourMs = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder searchCount(long value) {
            this.searchCount = value;
            return this;
        }

        public final Builder totalSearchTimeMs(double value) {
            this.totalSearchTimeMs = value;
            return this;
        }

        public final Builder averageSearchTimePerBucketMs(Number value) {
            this.averageSearchTimePerBucketMs = value;
            return this;
        }

        @Override
        public DatafeedTimingStats build() {
            this._checkSingleUse();
            return new DatafeedTimingStats(this);
        }
    }
}

