/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.BucketInfluencer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class BucketSummary
implements JsonpSerializable {
    private final double anomalyScore;
    private final List<BucketInfluencer> bucketInfluencers;
    private final Time bucketSpan;
    private final long eventCount;
    private final double initialAnomalyScore;
    private final boolean isInterim;
    private final String jobId;
    private final double processingTimeMs;
    private final String resultType;
    private final Time timestamp;
    public static final JsonpDeserializer<BucketSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketSummary::setupBucketSummaryDeserializer);

    private BucketSummary(Builder builder) {
        this.anomalyScore = ApiTypeHelper.requireNonNull(builder.anomalyScore, this, "anomalyScore");
        this.bucketInfluencers = ApiTypeHelper.unmodifiableRequired(builder.bucketInfluencers, (Object)this, "bucketInfluencers");
        this.bucketSpan = ApiTypeHelper.requireNonNull(builder.bucketSpan, this, "bucketSpan");
        this.eventCount = ApiTypeHelper.requireNonNull(builder.eventCount, this, "eventCount");
        this.initialAnomalyScore = ApiTypeHelper.requireNonNull(builder.initialAnomalyScore, this, "initialAnomalyScore");
        this.isInterim = ApiTypeHelper.requireNonNull(builder.isInterim, this, "isInterim");
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.processingTimeMs = ApiTypeHelper.requireNonNull(builder.processingTimeMs, this, "processingTimeMs");
        this.resultType = ApiTypeHelper.requireNonNull(builder.resultType, this, "resultType");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static BucketSummary of(Function<Builder, ObjectBuilder<BucketSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double anomalyScore() {
        return this.anomalyScore;
    }

    public final List<BucketInfluencer> bucketInfluencers() {
        return this.bucketInfluencers;
    }

    public final Time bucketSpan() {
        return this.bucketSpan;
    }

    public final long eventCount() {
        return this.eventCount;
    }

    public final double initialAnomalyScore() {
        return this.initialAnomalyScore;
    }

    public final boolean isInterim() {
        return this.isInterim;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final double processingTimeMs() {
        return this.processingTimeMs;
    }

    public final String resultType() {
        return this.resultType;
    }

    public final Time timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("anomaly_score");
        generator.write(this.anomalyScore);
        if (ApiTypeHelper.isDefined(this.bucketInfluencers)) {
            generator.writeKey("bucket_influencers");
            generator.writeStartArray();
            for (BucketInfluencer item0 : this.bucketInfluencers) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("bucket_span");
        this.bucketSpan.serialize(generator, mapper);
        generator.writeKey("event_count");
        generator.write(this.eventCount);
        generator.writeKey("initial_anomaly_score");
        generator.write(this.initialAnomalyScore);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("processing_time_ms");
        generator.write(this.processingTimeMs);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
    }

    protected static void setupBucketSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::anomalyScore, JsonpDeserializer.doubleDeserializer(), "anomaly_score");
        op.add(Builder::bucketInfluencers, JsonpDeserializer.arrayDeserializer(BucketInfluencer._DESERIALIZER), "bucket_influencers");
        op.add(Builder::bucketSpan, Time._DESERIALIZER, "bucket_span");
        op.add(Builder::eventCount, JsonpDeserializer.longDeserializer(), "event_count");
        op.add(Builder::initialAnomalyScore, JsonpDeserializer.doubleDeserializer(), "initial_anomaly_score");
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::processingTimeMs, JsonpDeserializer.doubleDeserializer(), "processing_time_ms");
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type");
        op.add(Builder::timestamp, Time._DESERIALIZER, "timestamp");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<BucketSummary> {
        private Double anomalyScore;
        private List<BucketInfluencer> bucketInfluencers;
        private Time bucketSpan;
        private Long eventCount;
        private Double initialAnomalyScore;
        private Boolean isInterim;
        private String jobId;
        private Double processingTimeMs;
        private String resultType;
        private Time timestamp;

        public final Builder anomalyScore(double value) {
            this.anomalyScore = value;
            return this;
        }

        public final Builder bucketInfluencers(List<BucketInfluencer> list) {
            this.bucketInfluencers = Builder._listAddAll(this.bucketInfluencers, list);
            return this;
        }

        public final Builder bucketInfluencers(BucketInfluencer value, BucketInfluencer ... values) {
            this.bucketInfluencers = Builder._listAdd(this.bucketInfluencers, value, values);
            return this;
        }

        public final Builder bucketInfluencers(Function<BucketInfluencer.Builder, ObjectBuilder<BucketInfluencer>> fn) {
            return this.bucketInfluencers(fn.apply(new BucketInfluencer.Builder()).build(), new BucketInfluencer[0]);
        }

        public final Builder bucketSpan(Time value) {
            this.bucketSpan = value;
            return this;
        }

        public final Builder bucketSpan(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.bucketSpan(fn.apply(new Time.Builder()).build());
        }

        public final Builder eventCount(long value) {
            this.eventCount = value;
            return this;
        }

        public final Builder initialAnomalyScore(double value) {
            this.initialAnomalyScore = value;
            return this;
        }

        public final Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder processingTimeMs(double value) {
            this.processingTimeMs = value;
            return this;
        }

        public final Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public final Builder timestamp(Time value) {
            this.timestamp = value;
            return this;
        }

        public final Builder timestamp(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timestamp(fn.apply(new Time.Builder()).build());
        }

        @Override
        public BucketSummary build() {
            this._checkSingleUse();
            return new BucketSummary(this);
        }
    }
}

