/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.GetFieldMappingResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetFieldMappingRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoIndices;
    private final List<ExpandWildcard> expandWildcards;
    private final List<String> fields;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean includeDefaults;
    @Nullable
    private final Boolean includeTypeName;
    private final List<String> index;
    @Nullable
    private final Boolean local;
    public static final Endpoint<GetFieldMappingRequest, GetFieldMappingResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetFieldMappingRequest, GetFieldMappingResponse>("es/indices.get_field_mapping", request -> "GET", request -> {
        boolean _index = true;
        int _fields = 2;
        int propsSet = 0;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= 1;
        }
        if ((propsSet |= 2) == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_mapping");
            buf.append("/field");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.fields.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_mapping");
            buf.append("/field");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.fields.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.includeTypeName != null) {
            params.put("include_type_name", String.valueOf(request.includeTypeName));
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.includeDefaults != null) {
            params.put("include_defaults", String.valueOf(request.includeDefaults));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetFieldMappingResponse._DESERIALIZER);

    private GetFieldMappingRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.includeDefaults = builder.includeDefaults;
        this.includeTypeName = builder.includeTypeName;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.local = builder.local;
    }

    public static GetFieldMappingRequest of(Function<Builder, ObjectBuilder<GetFieldMappingRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Nullable
    public final Boolean includeTypeName() {
        return this.includeTypeName;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetFieldMappingRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        private List<String> fields;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean includeDefaults;
        @Nullable
        private Boolean includeTypeName;
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean local;

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder includeDefaults(@Nullable Boolean value) {
            this.includeDefaults = value;
            return this;
        }

        public final Builder includeTypeName(@Nullable Boolean value) {
            this.includeTypeName = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        @Override
        public GetFieldMappingRequest build() {
            this._checkSingleUse();
            return new GetFieldMappingRequest(this);
        }
    }
}

