/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.TimeUnit;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.MlDatafeedsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class MlDatafeedsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final String datafeedId;
    @Nullable
    private final TimeUnit time;
    public static final Endpoint<MlDatafeedsRequest, MlDatafeedsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MlDatafeedsRequest, MlDatafeedsResponse>("es/cat.ml_datafeeds", request -> "GET", request -> {
        boolean _datafeedId = true;
        boolean propsSet = false;
        if (request.datafeedId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/datafeeds");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/ml");
            buf.append("/datafeeds");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.datafeedId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.time != null) {
            params.put("time", request.time.jsonValue());
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, MlDatafeedsResponse._DESERIALIZER);

    private MlDatafeedsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.datafeedId = builder.datafeedId;
        this.time = builder.time;
    }

    public static MlDatafeedsRequest of(Function<Builder, ObjectBuilder<MlDatafeedsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public final TimeUnit time() {
        return this.time;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MlDatafeedsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private String datafeedId;
        @Nullable
        private TimeUnit time;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder datafeedId(@Nullable String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder time(@Nullable TimeUnit value) {
            this.time = value;
            return this;
        }

        @Override
        public MlDatafeedsRequest build() {
            this._checkSingleUse();
            return new MlDatafeedsRequest(this);
        }
    }
}

