/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeFieldType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RuntimeField
implements JsonpSerializable {
    @Nullable
    private final String format;
    @Nullable
    private final Script script;
    private final RuntimeFieldType type;
    public static final JsonpDeserializer<RuntimeField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeField::setupRuntimeFieldDeserializer);

    private RuntimeField(Builder builder) {
        this.format = builder.format;
        this.script = builder.script;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static RuntimeField of(Function<Builder, ObjectBuilder<RuntimeField>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    public final RuntimeFieldType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    protected static void setupRuntimeFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::type, RuntimeFieldType._DESERIALIZER, "type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RuntimeField> {
        @Nullable
        private String format;
        @Nullable
        private Script script;
        private RuntimeFieldType type;

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder type(RuntimeFieldType value) {
            this.type = value;
            return this;
        }

        @Override
        public RuntimeField build() {
            this._checkSingleUse();
            return new RuntimeField(this);
        }
    }
}

