/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Index
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final String docId;
    @Nullable
    private final Refresh refresh;
    public static final JsonpDeserializer<Index> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Index::setupIndexDeserializer);

    private Index(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.docId = builder.docId;
        this.refresh = builder.refresh;
    }

    public static Index of(Function<Builder, ObjectBuilder<Index>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String docId() {
        return this.docId;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (this.docId != null) {
            generator.writeKey("doc_id");
            generator.write(this.docId);
        }
        if (this.refresh != null) {
            generator.writeKey("refresh");
            this.refresh.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupIndexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::docId, JsonpDeserializer.stringDeserializer(), "doc_id");
        op.add(Builder::refresh, Refresh._DESERIALIZER, "refresh");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Index> {
        private String index;
        @Nullable
        private String docId;
        @Nullable
        private Refresh refresh;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder docId(@Nullable String value) {
            this.docId = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Index build() {
            this._checkSingleUse();
            return new Index(this);
        }
    }
}

