/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.has_privileges;

import co.elastic.clients.elasticsearch.security.IndexPrivilege;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class IndexPrivilegesCheck
implements JsonpSerializable {
    private final List<String> names;
    private final List<IndexPrivilege> privileges;
    public static final JsonpDeserializer<IndexPrivilegesCheck> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexPrivilegesCheck::setupIndexPrivilegesCheckDeserializer);

    private IndexPrivilegesCheck(Builder builder) {
        this.names = ApiTypeHelper.unmodifiableRequired(builder.names, (Object)this, "names");
        this.privileges = ApiTypeHelper.unmodifiableRequired(builder.privileges, (Object)this, "privileges");
    }

    public static IndexPrivilegesCheck of(Function<Builder, ObjectBuilder<IndexPrivilegesCheck>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> names() {
        return this.names;
    }

    public final List<IndexPrivilege> privileges() {
        return this.privileges;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.names)) {
            generator.writeKey("names");
            generator.writeStartArray();
            for (String string : this.names) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.privileges)) {
            generator.writeKey("privileges");
            generator.writeStartArray();
            for (IndexPrivilege indexPrivilege : this.privileges) {
                indexPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIndexPrivilegesCheckDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "names");
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(IndexPrivilege._DESERIALIZER), "privileges");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexPrivilegesCheck> {
        private List<String> names;
        private List<IndexPrivilege> privileges;

        public final Builder names(List<String> list) {
            this.names = Builder._listAddAll(this.names, list);
            return this;
        }

        public final Builder names(String value, String ... values) {
            this.names = Builder._listAdd(this.names, value, values);
            return this;
        }

        public final Builder privileges(List<IndexPrivilege> list) {
            this.privileges = Builder._listAddAll(this.privileges, list);
            return this;
        }

        public final Builder privileges(IndexPrivilege value, IndexPrivilege ... values) {
            this.privileges = Builder._listAdd(this.privileges, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexPrivilegesCheck build() {
            this._checkSingleUse();
            return new IndexPrivilegesCheck(this);
        }
    }
}

