/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.explain_lifecycle;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplain;
import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainPhaseExecution;
import co.elastic.clients.elasticsearch.ilm.explain_lifecycle.LifecycleExplainVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LifecycleExplainManaged
implements LifecycleExplainVariant,
JsonpSerializable {
    private final String action;
    private final String actionTimeMillis;
    private final Time age;
    @Nullable
    private final String failedStep;
    @Nullable
    private final Integer failedStepRetryCount;
    private final String index;
    @Nullable
    private final String indexCreationDateMillis;
    @Nullable
    private final Boolean isAutoRetryableError;
    private final String lifecycleDateMillis;
    private final String phase;
    private final String phaseTimeMillis;
    private final String policy;
    private final String step;
    private final Map<String, JsonData> stepInfo;
    private final String stepTimeMillis;
    private final LifecycleExplainPhaseExecution phaseExecution;
    @Nullable
    private final Time timeSinceIndexCreation;
    public static final JsonpDeserializer<LifecycleExplainManaged> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LifecycleExplainManaged::setupLifecycleExplainManagedDeserializer);

    private LifecycleExplainManaged(Builder builder) {
        this.action = ApiTypeHelper.requireNonNull(builder.action, this, "action");
        this.actionTimeMillis = ApiTypeHelper.requireNonNull(builder.actionTimeMillis, this, "actionTimeMillis");
        this.age = ApiTypeHelper.requireNonNull(builder.age, this, "age");
        this.failedStep = builder.failedStep;
        this.failedStepRetryCount = builder.failedStepRetryCount;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.indexCreationDateMillis = builder.indexCreationDateMillis;
        this.isAutoRetryableError = builder.isAutoRetryableError;
        this.lifecycleDateMillis = ApiTypeHelper.requireNonNull(builder.lifecycleDateMillis, this, "lifecycleDateMillis");
        this.phase = ApiTypeHelper.requireNonNull(builder.phase, this, "phase");
        this.phaseTimeMillis = ApiTypeHelper.requireNonNull(builder.phaseTimeMillis, this, "phaseTimeMillis");
        this.policy = ApiTypeHelper.requireNonNull(builder.policy, this, "policy");
        this.step = ApiTypeHelper.requireNonNull(builder.step, this, "step");
        this.stepInfo = ApiTypeHelper.unmodifiable(builder.stepInfo);
        this.stepTimeMillis = ApiTypeHelper.requireNonNull(builder.stepTimeMillis, this, "stepTimeMillis");
        this.phaseExecution = ApiTypeHelper.requireNonNull(builder.phaseExecution, this, "phaseExecution");
        this.timeSinceIndexCreation = builder.timeSinceIndexCreation;
    }

    public static LifecycleExplainManaged of(Function<Builder, ObjectBuilder<LifecycleExplainManaged>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public LifecycleExplain.Kind _lifecycleExplainKind() {
        return LifecycleExplain.Kind.True;
    }

    public final String action() {
        return this.action;
    }

    public final String actionTimeMillis() {
        return this.actionTimeMillis;
    }

    public final Time age() {
        return this.age;
    }

    @Nullable
    public final String failedStep() {
        return this.failedStep;
    }

    @Nullable
    public final Integer failedStepRetryCount() {
        return this.failedStepRetryCount;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String indexCreationDateMillis() {
        return this.indexCreationDateMillis;
    }

    @Nullable
    public final Boolean isAutoRetryableError() {
        return this.isAutoRetryableError;
    }

    public final String lifecycleDateMillis() {
        return this.lifecycleDateMillis;
    }

    public final String phase() {
        return this.phase;
    }

    public final String phaseTimeMillis() {
        return this.phaseTimeMillis;
    }

    public final String policy() {
        return this.policy;
    }

    public final String step() {
        return this.step;
    }

    public final Map<String, JsonData> stepInfo() {
        return this.stepInfo;
    }

    public final String stepTimeMillis() {
        return this.stepTimeMillis;
    }

    public final LifecycleExplainPhaseExecution phaseExecution() {
        return this.phaseExecution;
    }

    @Nullable
    public final Time timeSinceIndexCreation() {
        return this.timeSinceIndexCreation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("managed", "true");
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("action_time_millis");
        generator.write(this.actionTimeMillis);
        generator.writeKey("age");
        this.age.serialize(generator, mapper);
        if (this.failedStep != null) {
            generator.writeKey("failed_step");
            generator.write(this.failedStep);
        }
        if (this.failedStepRetryCount != null) {
            generator.writeKey("failed_step_retry_count");
            generator.write(this.failedStepRetryCount.intValue());
        }
        generator.writeKey("index");
        generator.write(this.index);
        if (this.indexCreationDateMillis != null) {
            generator.writeKey("index_creation_date_millis");
            generator.write(this.indexCreationDateMillis);
        }
        if (this.isAutoRetryableError != null) {
            generator.writeKey("is_auto_retryable_error");
            generator.write(this.isAutoRetryableError.booleanValue());
        }
        generator.writeKey("lifecycle_date_millis");
        generator.write(this.lifecycleDateMillis);
        generator.writeKey("phase");
        generator.write(this.phase);
        generator.writeKey("phase_time_millis");
        generator.write(this.phaseTimeMillis);
        generator.writeKey("policy");
        generator.write(this.policy);
        generator.writeKey("step");
        generator.write(this.step);
        if (ApiTypeHelper.isDefined(this.stepInfo)) {
            generator.writeKey("step_info");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.stepInfo.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("step_time_millis");
        generator.write(this.stepTimeMillis);
        generator.writeKey("phase_execution");
        this.phaseExecution.serialize(generator, mapper);
        if (this.timeSinceIndexCreation != null) {
            generator.writeKey("time_since_index_creation");
            this.timeSinceIndexCreation.serialize(generator, mapper);
        }
    }

    protected static void setupLifecycleExplainManagedDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action");
        op.add(Builder::actionTimeMillis, JsonpDeserializer.stringDeserializer(), "action_time_millis");
        op.add(Builder::age, Time._DESERIALIZER, "age");
        op.add(Builder::failedStep, JsonpDeserializer.stringDeserializer(), "failed_step");
        op.add(Builder::failedStepRetryCount, JsonpDeserializer.integerDeserializer(), "failed_step_retry_count");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::indexCreationDateMillis, JsonpDeserializer.stringDeserializer(), "index_creation_date_millis");
        op.add(Builder::isAutoRetryableError, JsonpDeserializer.booleanDeserializer(), "is_auto_retryable_error");
        op.add(Builder::lifecycleDateMillis, JsonpDeserializer.stringDeserializer(), "lifecycle_date_millis");
        op.add(Builder::phase, JsonpDeserializer.stringDeserializer(), "phase");
        op.add(Builder::phaseTimeMillis, JsonpDeserializer.stringDeserializer(), "phase_time_millis");
        op.add(Builder::policy, JsonpDeserializer.stringDeserializer(), "policy");
        op.add(Builder::step, JsonpDeserializer.stringDeserializer(), "step");
        op.add(Builder::stepInfo, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "step_info");
        op.add(Builder::stepTimeMillis, JsonpDeserializer.stringDeserializer(), "step_time_millis");
        op.add(Builder::phaseExecution, LifecycleExplainPhaseExecution._DESERIALIZER, "phase_execution");
        op.add(Builder::timeSinceIndexCreation, Time._DESERIALIZER, "time_since_index_creation");
        op.ignore("managed");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LifecycleExplainManaged> {
        private String action;
        private String actionTimeMillis;
        private Time age;
        @Nullable
        private String failedStep;
        @Nullable
        private Integer failedStepRetryCount;
        private String index;
        @Nullable
        private String indexCreationDateMillis;
        @Nullable
        private Boolean isAutoRetryableError;
        private String lifecycleDateMillis;
        private String phase;
        private String phaseTimeMillis;
        private String policy;
        private String step;
        @Nullable
        private Map<String, JsonData> stepInfo;
        private String stepTimeMillis;
        private LifecycleExplainPhaseExecution phaseExecution;
        @Nullable
        private Time timeSinceIndexCreation;

        public final Builder action(String value) {
            this.action = value;
            return this;
        }

        public final Builder actionTimeMillis(String value) {
            this.actionTimeMillis = value;
            return this;
        }

        public final Builder age(Time value) {
            this.age = value;
            return this;
        }

        public final Builder age(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.age(fn.apply(new Time.Builder()).build());
        }

        public final Builder failedStep(@Nullable String value) {
            this.failedStep = value;
            return this;
        }

        public final Builder failedStepRetryCount(@Nullable Integer value) {
            this.failedStepRetryCount = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder indexCreationDateMillis(@Nullable String value) {
            this.indexCreationDateMillis = value;
            return this;
        }

        public final Builder isAutoRetryableError(@Nullable Boolean value) {
            this.isAutoRetryableError = value;
            return this;
        }

        public final Builder lifecycleDateMillis(String value) {
            this.lifecycleDateMillis = value;
            return this;
        }

        public final Builder phase(String value) {
            this.phase = value;
            return this;
        }

        public final Builder phaseTimeMillis(String value) {
            this.phaseTimeMillis = value;
            return this;
        }

        public final Builder policy(String value) {
            this.policy = value;
            return this;
        }

        public final Builder step(String value) {
            this.step = value;
            return this;
        }

        public final Builder stepInfo(Map<String, JsonData> map) {
            this.stepInfo = Builder._mapPutAll(this.stepInfo, map);
            return this;
        }

        public final Builder stepInfo(String key, JsonData value) {
            this.stepInfo = Builder._mapPut(this.stepInfo, key, value);
            return this;
        }

        public final Builder stepTimeMillis(String value) {
            this.stepTimeMillis = value;
            return this;
        }

        public final Builder phaseExecution(LifecycleExplainPhaseExecution value) {
            this.phaseExecution = value;
            return this;
        }

        public final Builder phaseExecution(Function<LifecycleExplainPhaseExecution.Builder, ObjectBuilder<LifecycleExplainPhaseExecution>> fn) {
            return this.phaseExecution(fn.apply(new LifecycleExplainPhaseExecution.Builder()).build());
        }

        public final Builder timeSinceIndexCreation(@Nullable Time value) {
            this.timeSinceIndexCreation = value;
            return this;
        }

        public final Builder timeSinceIndexCreation(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeSinceIndexCreation(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LifecycleExplainManaged build() {
            this._checkSingleUse();
            return new LifecycleExplainManaged(this);
        }
    }
}

