/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.elasticsearch._types.ClusterStatistics;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.Profile;
import co.elastic.clients.elasticsearch.core.search.Suggestion;
import co.elastic.clients.json.ExternallyTaggedUnion;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AsyncSearch<TDocument>
implements JsonpSerializable {
    private final Map<String, Aggregate> aggregations;
    @Nullable
    private final ClusterStatistics clusters;
    private final Map<String, JsonData> fields;
    private final HitsMetadata<TDocument> hits;
    @Nullable
    private final Double maxScore;
    @Nullable
    private final Long numReducePhases;
    @Nullable
    private final Profile profile;
    @Nullable
    private final String pitId;
    @Nullable
    private final String scrollId;
    private final ShardStatistics shards;
    private final Map<String, List<Suggestion<TDocument>>> suggest;
    @Nullable
    private final Boolean terminatedEarly;
    private final boolean timedOut;
    private final long took;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<AsyncSearch<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> AsyncSearch.createAsyncSearchDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:async_search._types.TDocument")));

    private AsyncSearch(Builder<TDocument> builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(((Builder)builder).aggregations);
        this.clusters = ((Builder)builder).clusters;
        this.fields = ApiTypeHelper.unmodifiable(((Builder)builder).fields);
        this.hits = ApiTypeHelper.requireNonNull(((Builder)builder).hits, this, "hits");
        this.maxScore = ((Builder)builder).maxScore;
        this.numReducePhases = ((Builder)builder).numReducePhases;
        this.profile = ((Builder)builder).profile;
        this.pitId = ((Builder)builder).pitId;
        this.scrollId = ((Builder)builder).scrollId;
        this.shards = ApiTypeHelper.requireNonNull(((Builder)builder).shards, this, "shards");
        this.suggest = ApiTypeHelper.unmodifiable(((Builder)builder).suggest);
        this.terminatedEarly = ((Builder)builder).terminatedEarly;
        this.timedOut = ApiTypeHelper.requireNonNull(((Builder)builder).timedOut, this, "timedOut");
        this.took = ApiTypeHelper.requireNonNull(((Builder)builder).took, this, "took");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> AsyncSearch<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<AsyncSearch<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregate> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final ClusterStatistics clusters() {
        return this.clusters;
    }

    public final Map<String, JsonData> fields() {
        return this.fields;
    }

    public final HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    @Nullable
    public final Double maxScore() {
        return this.maxScore;
    }

    @Nullable
    public final Long numReducePhases() {
        return this.numReducePhases;
    }

    @Nullable
    public final Profile profile() {
        return this.profile;
    }

    @Nullable
    public final String pitId() {
        return this.pitId;
    }

    @Nullable
    public final String scrollId() {
        return this.scrollId;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final Map<String, List<Suggestion<TDocument>>> suggest() {
        return this.suggest;
    }

    @Nullable
    public final Boolean terminatedEarly() {
        return this.terminatedEarly;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final long took() {
        return this.took;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            ExternallyTaggedUnion.serializeTypedKeys(this.aggregations, generator, mapper);
        }
        if (this.clusters != null) {
            generator.writeKey("_clusters");
            this.clusters.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
        if (this.numReducePhases != null) {
            generator.writeKey("num_reduce_phases");
            generator.write(this.numReducePhases.longValue());
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            this.profile.serialize(generator, mapper);
        }
        if (this.pitId != null) {
            generator.writeKey("pit_id");
            generator.write(this.pitId);
        }
        if (this.scrollId != null) {
            generator.writeKey("_scroll_id");
            generator.write(this.scrollId);
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.suggest)) {
            generator.writeKey("suggest");
            ExternallyTaggedUnion.serializeTypedKeysArray(this.suggest, generator, mapper);
        }
        if (this.terminatedEarly != null) {
            generator.writeKey("terminated_early");
            generator.write(this.terminatedEarly.booleanValue());
        }
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("took");
        generator.write(this.took);
    }

    public static <TDocument> JsonpDeserializer<AsyncSearch<TDocument>> createAsyncSearchDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> AsyncSearch.setupAsyncSearchDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupAsyncSearchDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::aggregations, Aggregate._TYPED_KEYS_DESERIALIZER, "aggregations");
        op.add(Builder::clusters, ClusterStatistics._DESERIALIZER, "_clusters");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields");
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits");
        op.add(Builder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score");
        op.add(Builder::numReducePhases, JsonpDeserializer.longDeserializer(), "num_reduce_phases");
        op.add(Builder::profile, Profile._DESERIALIZER, "profile");
        op.add(Builder::pitId, JsonpDeserializer.stringDeserializer(), "pit_id");
        op.add(Builder::scrollId, JsonpDeserializer.stringDeserializer(), "_scroll_id");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::suggest, ExternallyTaggedUnion.arrayMapDeserializer(Suggestion.createSuggestionDeserializer(tDocumentDeserializer)), "suggest");
        op.add(Builder::terminatedEarly, JsonpDeserializer.booleanDeserializer(), "terminated_early");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
    }

    public static class Builder<TDocument>
    extends WithJsonObjectBuilderBase<Builder<TDocument>>
    implements ObjectBuilder<AsyncSearch<TDocument>> {
        @Nullable
        private Map<String, Aggregate> aggregations;
        @Nullable
        private ClusterStatistics clusters;
        @Nullable
        private Map<String, JsonData> fields;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private Double maxScore;
        @Nullable
        private Long numReducePhases;
        @Nullable
        private Profile profile;
        @Nullable
        private String pitId;
        @Nullable
        private String scrollId;
        private ShardStatistics shards;
        @Nullable
        private Map<String, List<Suggestion<TDocument>>> suggest;
        @Nullable
        private Boolean terminatedEarly;
        private Boolean timedOut;
        private Long took;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> aggregations(Map<String, Aggregate> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder<TDocument> aggregations(String key, Aggregate value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder<TDocument> aggregations(String key, Function<Aggregate.Builder, ObjectBuilder<Aggregate>> fn) {
            return this.aggregations(key, fn.apply(new Aggregate.Builder()).build());
        }

        public final Builder<TDocument> clusters(@Nullable ClusterStatistics value) {
            this.clusters = value;
            return this;
        }

        public final Builder<TDocument> clusters(Function<ClusterStatistics.Builder, ObjectBuilder<ClusterStatistics>> fn) {
            return this.clusters(fn.apply(new ClusterStatistics.Builder()).build());
        }

        public final Builder<TDocument> fields(Map<String, JsonData> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder<TDocument> fields(String key, JsonData value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder<TDocument> hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return this;
        }

        public final Builder<TDocument> hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public final Builder<TDocument> maxScore(@Nullable Double value) {
            this.maxScore = value;
            return this;
        }

        public final Builder<TDocument> numReducePhases(@Nullable Long value) {
            this.numReducePhases = value;
            return this;
        }

        public final Builder<TDocument> profile(@Nullable Profile value) {
            this.profile = value;
            return this;
        }

        public final Builder<TDocument> profile(Function<Profile.Builder, ObjectBuilder<Profile>> fn) {
            return this.profile(fn.apply(new Profile.Builder()).build());
        }

        public final Builder<TDocument> pitId(@Nullable String value) {
            this.pitId = value;
            return this;
        }

        public final Builder<TDocument> scrollId(@Nullable String value) {
            this.scrollId = value;
            return this;
        }

        public final Builder<TDocument> shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder<TDocument> shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder<TDocument> suggest(Map<String, List<Suggestion<TDocument>>> map) {
            this.suggest = Builder._mapPutAll(this.suggest, map);
            return this;
        }

        public final Builder<TDocument> suggest(String key, List<Suggestion<TDocument>> value) {
            this.suggest = Builder._mapPut(this.suggest, key, value);
            return this;
        }

        public final Builder<TDocument> terminatedEarly(@Nullable Boolean value) {
            this.terminatedEarly = value;
            return this;
        }

        public final Builder<TDocument> timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder<TDocument> took(long value) {
            this.took = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public AsyncSearch<TDocument> build() {
            this._checkSingleUse();
            return new AsyncSearch(this);
        }
    }
}

