/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cluster.RerouteResponse;
import co.elastic.clients.elasticsearch.cluster.reroute.Command;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RerouteRequest
extends RequestBase
implements JsonpSerializable {
    private final List<Command> commands;
    @Nullable
    private final Boolean dryRun;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final Time masterTimeout;
    private final List<String> metric;
    @Nullable
    private final Boolean retryFailed;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<RerouteRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteRequest::setupRerouteRequestDeserializer);
    public static final Endpoint<RerouteRequest, RerouteResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RerouteRequest, RerouteResponse>("es/cluster.reroute", request -> "POST", request -> "/_cluster/reroute", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.explain != null) {
            params.put("explain", String.valueOf(request.explain));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.metric)) {
            params.put("metric", request.metric.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.dryRun != null) {
            params.put("dry_run", String.valueOf(request.dryRun));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.retryFailed != null) {
            params.put("retry_failed", String.valueOf(request.retryFailed));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, RerouteResponse._DESERIALIZER);

    private RerouteRequest(Builder builder) {
        this.commands = ApiTypeHelper.unmodifiable(builder.commands);
        this.dryRun = builder.dryRun;
        this.explain = builder.explain;
        this.masterTimeout = builder.masterTimeout;
        this.metric = ApiTypeHelper.unmodifiable(builder.metric);
        this.retryFailed = builder.retryFailed;
        this.timeout = builder.timeout;
    }

    public static RerouteRequest of(Function<Builder, ObjectBuilder<RerouteRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Command> commands() {
        return this.commands;
    }

    @Nullable
    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> metric() {
        return this.metric;
    }

    @Nullable
    public final Boolean retryFailed() {
        return this.retryFailed;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.commands)) {
            generator.writeKey("commands");
            generator.writeStartArray();
            for (Command item0 : this.commands) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRerouteRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::commands, JsonpDeserializer.arrayDeserializer(Command._DESERIALIZER), "commands");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RerouteRequest> {
        @Nullable
        private List<Command> commands;
        @Nullable
        private Boolean dryRun;
        @Nullable
        private Boolean explain;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<String> metric;
        @Nullable
        private Boolean retryFailed;
        @Nullable
        private Time timeout;

        public final Builder commands(List<Command> list) {
            this.commands = Builder._listAddAll(this.commands, list);
            return this;
        }

        public final Builder commands(Command value, Command ... values) {
            this.commands = Builder._listAdd(this.commands, value, values);
            return this;
        }

        public final Builder commands(Function<Command.Builder, ObjectBuilder<Command>> fn) {
            return this.commands(fn.apply(new Command.Builder()).build(), new Command[0]);
        }

        public final Builder dryRun(@Nullable Boolean value) {
            this.dryRun = value;
            return this;
        }

        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder metric(List<String> list) {
            this.metric = Builder._listAddAll(this.metric, list);
            return this;
        }

        public final Builder metric(String value, String ... values) {
            this.metric = Builder._listAdd(this.metric, value, values);
            return this;
        }

        public final Builder retryFailed(@Nullable Boolean value) {
            this.retryFailed = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RerouteRequest build() {
            this._checkSingleUse();
            return new RerouteRequest(this);
        }
    }
}

