/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ssl.certificates;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CertificateInformation
implements JsonpSerializable {
    @Nullable
    private final String alias;
    private final String expiry;
    private final String format;
    private final boolean hasPrivateKey;
    @Nullable
    private final String issuer;
    private final String path;
    private final String serialNumber;
    private final String subjectDn;
    public static final JsonpDeserializer<CertificateInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CertificateInformation::setupCertificateInformationDeserializer);

    private CertificateInformation(Builder builder) {
        this.alias = builder.alias;
        this.expiry = ApiTypeHelper.requireNonNull(builder.expiry, this, "expiry");
        this.format = ApiTypeHelper.requireNonNull(builder.format, this, "format");
        this.hasPrivateKey = ApiTypeHelper.requireNonNull(builder.hasPrivateKey, this, "hasPrivateKey");
        this.issuer = builder.issuer;
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
        this.serialNumber = ApiTypeHelper.requireNonNull(builder.serialNumber, this, "serialNumber");
        this.subjectDn = ApiTypeHelper.requireNonNull(builder.subjectDn, this, "subjectDn");
    }

    public static CertificateInformation of(Function<Builder, ObjectBuilder<CertificateInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String alias() {
        return this.alias;
    }

    public final String expiry() {
        return this.expiry;
    }

    public final String format() {
        return this.format;
    }

    public final boolean hasPrivateKey() {
        return this.hasPrivateKey;
    }

    @Nullable
    public final String issuer() {
        return this.issuer;
    }

    public final String path() {
        return this.path;
    }

    public final String serialNumber() {
        return this.serialNumber;
    }

    public final String subjectDn() {
        return this.subjectDn;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alias != null) {
            generator.writeKey("alias");
            generator.write(this.alias);
        }
        generator.writeKey("expiry");
        generator.write(this.expiry);
        generator.writeKey("format");
        generator.write(this.format);
        generator.writeKey("has_private_key");
        generator.write(this.hasPrivateKey);
        if (this.issuer != null) {
            generator.writeKey("issuer");
            generator.write(this.issuer);
        }
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("serial_number");
        generator.write(this.serialNumber);
        generator.writeKey("subject_dn");
        generator.write(this.subjectDn);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCertificateInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::alias, JsonpDeserializer.stringDeserializer(), "alias");
        op.add(Builder::expiry, JsonpDeserializer.stringDeserializer(), "expiry");
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::hasPrivateKey, JsonpDeserializer.booleanDeserializer(), "has_private_key");
        op.add(Builder::issuer, JsonpDeserializer.stringDeserializer(), "issuer");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::serialNumber, JsonpDeserializer.stringDeserializer(), "serial_number");
        op.add(Builder::subjectDn, JsonpDeserializer.stringDeserializer(), "subject_dn");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CertificateInformation> {
        @Nullable
        private String alias;
        private String expiry;
        private String format;
        private Boolean hasPrivateKey;
        @Nullable
        private String issuer;
        private String path;
        private String serialNumber;
        private String subjectDn;

        public final Builder alias(@Nullable String value) {
            this.alias = value;
            return this;
        }

        public final Builder expiry(String value) {
            this.expiry = value;
            return this;
        }

        public final Builder format(String value) {
            this.format = value;
            return this;
        }

        public final Builder hasPrivateKey(boolean value) {
            this.hasPrivateKey = value;
            return this;
        }

        public final Builder issuer(@Nullable String value) {
            this.issuer = value;
            return this;
        }

        public final Builder path(String value) {
            this.path = value;
            return this;
        }

        public final Builder serialNumber(String value) {
            this.serialNumber = value;
            return this;
        }

        public final Builder subjectDn(String value) {
            this.subjectDn = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CertificateInformation build() {
            this._checkSingleUse();
            return new CertificateInformation(this);
        }
    }
}

