/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch.ilm.Phases;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IlmPolicy
implements JsonpSerializable {
    private final Phases phases;
    @Nullable
    private final String name;
    public static final JsonpDeserializer<IlmPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IlmPolicy::setupIlmPolicyDeserializer);

    private IlmPolicy(Builder builder) {
        this.phases = ApiTypeHelper.requireNonNull(builder.phases, this, "phases");
        this.name = builder.name;
    }

    public static IlmPolicy of(Function<Builder, ObjectBuilder<IlmPolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Phases phases() {
        return this.phases;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("phases");
        this.phases.serialize(generator, mapper);
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
    }

    protected static void setupIlmPolicyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::phases, Phases._DESERIALIZER, "phases");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IlmPolicy> {
        private Phases phases;
        @Nullable
        private String name;

        public final Builder phases(Phases value) {
            this.phases = value;
            return this;
        }

        public final Builder phases(Function<Phases.Builder, ObjectBuilder<Phases>> fn) {
            return this.phases(fn.apply(new Phases.Builder()).build());
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IlmPolicy build() {
            this._checkSingleUse();
            return new IlmPolicy(this);
        }
    }
}

