/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.searchable_snapshots;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.searchable_snapshots.SearchableSnapshotsStatsResponse;
import co.elastic.clients.elasticsearch.searchable_snapshots.StatsLevel;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SearchableSnapshotsStatsRequest
extends RequestBase {
    private final List<String> index;
    @Nullable
    private final StatsLevel level;
    public static final Endpoint<SearchableSnapshotsStatsRequest, SearchableSnapshotsStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SearchableSnapshotsStatsRequest, SearchableSnapshotsStatsResponse>("es/searchable_snapshots.stats", request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_searchable_snapshots");
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_searchable_snapshots");
            buf.append("/stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.level != null) {
            params.put("level", request.level.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, SearchableSnapshotsStatsResponse._DESERIALIZER);

    private SearchableSnapshotsStatsRequest(Builder builder) {
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.level = builder.level;
    }

    public static SearchableSnapshotsStatsRequest of(Function<Builder, ObjectBuilder<SearchableSnapshotsStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final StatsLevel level() {
        return this.level;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SearchableSnapshotsStatsRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private StatsLevel level;

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder level(@Nullable StatsLevel value) {
            this.level = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchableSnapshotsStatsRequest build() {
            this._checkSingleUse();
            return new SearchableSnapshotsStatsRequest(this);
        }
    }
}

