/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.Conflicts;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.Slices;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.WaitForActiveShards;
import co.elastic.clients.elasticsearch.core.ReindexResponse;
import co.elastic.clients.elasticsearch.core.reindex.Destination;
import co.elastic.clients.elasticsearch.core.reindex.Source;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ReindexRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Conflicts conflicts;
    private final Destination dest;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final Boolean refresh;
    @Nullable
    private final Long requestsPerSecond;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final Script script;
    @Nullable
    private final Time scroll;
    @Nullable
    private final Long size;
    @Nullable
    private final Slices slices;
    private final Source source;
    @Nullable
    private final Time timeout;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    @Nullable
    private final Boolean waitForCompletion;
    public static final JsonpDeserializer<ReindexRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexRequest::setupReindexRequestDeserializer);
    public static final Endpoint<ReindexRequest, ReindexResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ReindexRequest, ReindexResponse>("es/reindex", request -> "POST", request -> "/_reindex", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.slices != null) {
            params.put("slices", request.slices._toJsonString());
        }
        if (request.requestsPerSecond != null) {
            params.put("requests_per_second", String.valueOf(request.requestsPerSecond));
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        if (request.scroll != null) {
            params.put("scroll", request.scroll._toJsonString());
        }
        if (request.refresh != null) {
            params.put("refresh", String.valueOf(request.refresh));
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ReindexResponse._DESERIALIZER);

    private ReindexRequest(Builder builder) {
        this.conflicts = builder.conflicts;
        this.dest = ApiTypeHelper.requireNonNull(builder.dest, this, "dest");
        this.maxDocs = builder.maxDocs;
        this.refresh = builder.refresh;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.requireAlias = builder.requireAlias;
        this.script = builder.script;
        this.scroll = builder.scroll;
        this.size = builder.size;
        this.slices = builder.slices;
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.timeout = builder.timeout;
        this.waitForActiveShards = builder.waitForActiveShards;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static ReindexRequest of(Function<Builder, ObjectBuilder<ReindexRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Conflicts conflicts() {
        return this.conflicts;
    }

    public final Destination dest() {
        return this.dest;
    }

    @Nullable
    public final Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public final Boolean refresh() {
        return this.refresh;
    }

    @Nullable
    public final Long requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Time scroll() {
        return this.scroll;
    }

    @Nullable
    public final Long size() {
        return this.size;
    }

    @Nullable
    public final Slices slices() {
        return this.slices;
    }

    public final Source source() {
        return this.source;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.conflicts != null) {
            generator.writeKey("conflicts");
            this.conflicts.serialize(generator, mapper);
        }
        generator.writeKey("dest");
        this.dest.serialize(generator, mapper);
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.longValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.longValue());
        }
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
    }

    protected static void setupReindexRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::conflicts, Conflicts._DESERIALIZER, "conflicts");
        op.add(Builder::dest, Destination._DESERIALIZER, "dest");
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::size, JsonpDeserializer.longDeserializer(), "size");
        op.add(Builder::source, Source._DESERIALIZER, "source");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ReindexRequest> {
        @Nullable
        private Conflicts conflicts;
        private Destination dest;
        @Nullable
        private Long maxDocs;
        @Nullable
        private Boolean refresh;
        @Nullable
        private Long requestsPerSecond;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private Script script;
        @Nullable
        private Time scroll;
        @Nullable
        private Long size;
        @Nullable
        private Slices slices;
        private Source source;
        @Nullable
        private Time timeout;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        @Nullable
        private Boolean waitForCompletion;

        public final Builder conflicts(@Nullable Conflicts value) {
            this.conflicts = value;
            return this;
        }

        public final Builder dest(Destination value) {
            this.dest = value;
            return this;
        }

        public final Builder dest(Function<Destination.Builder, ObjectBuilder<Destination>> fn) {
            return this.dest(fn.apply(new Destination.Builder()).build());
        }

        public final Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public final Builder refresh(@Nullable Boolean value) {
            this.refresh = value;
            return this;
        }

        public final Builder requestsPerSecond(@Nullable Long value) {
            this.requestsPerSecond = value;
            return this;
        }

        public final Builder requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder scroll(@Nullable Time value) {
            this.scroll = value;
            return this;
        }

        public final Builder scroll(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scroll(fn.apply(new Time.Builder()).build());
        }

        public final Builder size(@Nullable Long value) {
            this.size = value;
            return this;
        }

        public final Builder slices(@Nullable Slices value) {
            this.slices = value;
            return this;
        }

        public final Builder slices(Function<Slices.Builder, ObjectBuilder<Slices>> fn) {
            return this.slices(fn.apply(new Slices.Builder()).build());
        }

        public final Builder source(Source value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<Source.Builder, ObjectBuilder<Source>> fn) {
            return this.source(fn.apply(new Source.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReindexRequest build() {
            this._checkSingleUse();
            return new ReindexRequest(this);
        }
    }
}

