/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GrantApiKeyResponse
implements JsonpSerializable {
    private final String apiKey;
    private final String id;
    private final String name;
    @Nullable
    private final String expiration;
    public static final JsonpDeserializer<GrantApiKeyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GrantApiKeyResponse::setupGrantApiKeyResponseDeserializer);

    private GrantApiKeyResponse(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.expiration = builder.expiration;
    }

    public static GrantApiKeyResponse of(Function<Builder, ObjectBuilder<GrantApiKeyResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final String expiration() {
        return this.expiration;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("name");
        generator.write(this.name);
        if (this.expiration != null) {
            generator.writeKey("expiration");
            generator.write(this.expiration);
        }
    }

    protected static void setupGrantApiKeyResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::expiration, JsonpDeserializer.stringDeserializer(), "expiration");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GrantApiKeyResponse> {
        private String apiKey;
        private String id;
        private String name;
        @Nullable
        private String expiration;

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder expiration(@Nullable String value) {
            this.expiration = value;
            return this;
        }

        @Override
        public GrantApiKeyResponse build() {
            this._checkSingleUse();
            return new GrantApiKeyResponse(this);
        }
    }
}

