/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.RepositoryLocation;
import co.elastic.clients.elasticsearch.nodes.RequestCounts;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RepositoryMeteringInformation
implements JsonpSerializable {
    private final String repositoryName;
    private final String repositoryType;
    private final RepositoryLocation repositoryLocation;
    private final String repositoryEphemeralId;
    private final String repositoryStartedAt;
    @Nullable
    private final String repositoryStoppedAt;
    private final boolean archived;
    @Nullable
    private final Long clusterVersion;
    private final RequestCounts requestCounts;
    public static final JsonpDeserializer<RepositoryMeteringInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositoryMeteringInformation::setupRepositoryMeteringInformationDeserializer);

    private RepositoryMeteringInformation(Builder builder) {
        this.repositoryName = ApiTypeHelper.requireNonNull(builder.repositoryName, this, "repositoryName");
        this.repositoryType = ApiTypeHelper.requireNonNull(builder.repositoryType, this, "repositoryType");
        this.repositoryLocation = ApiTypeHelper.requireNonNull(builder.repositoryLocation, this, "repositoryLocation");
        this.repositoryEphemeralId = ApiTypeHelper.requireNonNull(builder.repositoryEphemeralId, this, "repositoryEphemeralId");
        this.repositoryStartedAt = ApiTypeHelper.requireNonNull(builder.repositoryStartedAt, this, "repositoryStartedAt");
        this.repositoryStoppedAt = builder.repositoryStoppedAt;
        this.archived = ApiTypeHelper.requireNonNull(builder.archived, this, "archived");
        this.clusterVersion = builder.clusterVersion;
        this.requestCounts = ApiTypeHelper.requireNonNull(builder.requestCounts, this, "requestCounts");
    }

    public static RepositoryMeteringInformation of(Function<Builder, ObjectBuilder<RepositoryMeteringInformation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String repositoryType() {
        return this.repositoryType;
    }

    public final RepositoryLocation repositoryLocation() {
        return this.repositoryLocation;
    }

    public final String repositoryEphemeralId() {
        return this.repositoryEphemeralId;
    }

    public final String repositoryStartedAt() {
        return this.repositoryStartedAt;
    }

    @Nullable
    public final String repositoryStoppedAt() {
        return this.repositoryStoppedAt;
    }

    public final boolean archived() {
        return this.archived;
    }

    @Nullable
    public final Long clusterVersion() {
        return this.clusterVersion;
    }

    public final RequestCounts requestCounts() {
        return this.requestCounts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("repository_name");
        generator.write(this.repositoryName);
        generator.writeKey("repository_type");
        generator.write(this.repositoryType);
        generator.writeKey("repository_location");
        this.repositoryLocation.serialize(generator, mapper);
        generator.writeKey("repository_ephemeral_id");
        generator.write(this.repositoryEphemeralId);
        generator.writeKey("repository_started_at");
        generator.write(this.repositoryStartedAt);
        if (this.repositoryStoppedAt != null) {
            generator.writeKey("repository_stopped_at");
            generator.write(this.repositoryStoppedAt);
        }
        generator.writeKey("archived");
        generator.write(this.archived);
        if (this.clusterVersion != null) {
            generator.writeKey("cluster_version");
            generator.write(this.clusterVersion.longValue());
        }
        generator.writeKey("request_counts");
        this.requestCounts.serialize(generator, mapper);
    }

    protected static void setupRepositoryMeteringInformationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::repositoryName, JsonpDeserializer.stringDeserializer(), "repository_name");
        op.add(Builder::repositoryType, JsonpDeserializer.stringDeserializer(), "repository_type");
        op.add(Builder::repositoryLocation, RepositoryLocation._DESERIALIZER, "repository_location");
        op.add(Builder::repositoryEphemeralId, JsonpDeserializer.stringDeserializer(), "repository_ephemeral_id");
        op.add(Builder::repositoryStartedAt, JsonpDeserializer.stringDeserializer(), "repository_started_at");
        op.add(Builder::repositoryStoppedAt, JsonpDeserializer.stringDeserializer(), "repository_stopped_at");
        op.add(Builder::archived, JsonpDeserializer.booleanDeserializer(), "archived");
        op.add(Builder::clusterVersion, JsonpDeserializer.longDeserializer(), "cluster_version");
        op.add(Builder::requestCounts, RequestCounts._DESERIALIZER, "request_counts");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RepositoryMeteringInformation> {
        private String repositoryName;
        private String repositoryType;
        private RepositoryLocation repositoryLocation;
        private String repositoryEphemeralId;
        private String repositoryStartedAt;
        @Nullable
        private String repositoryStoppedAt;
        private Boolean archived;
        @Nullable
        private Long clusterVersion;
        private RequestCounts requestCounts;

        public final Builder repositoryName(String value) {
            this.repositoryName = value;
            return this;
        }

        public final Builder repositoryType(String value) {
            this.repositoryType = value;
            return this;
        }

        public final Builder repositoryLocation(RepositoryLocation value) {
            this.repositoryLocation = value;
            return this;
        }

        public final Builder repositoryLocation(Function<RepositoryLocation.Builder, ObjectBuilder<RepositoryLocation>> fn) {
            return this.repositoryLocation(fn.apply(new RepositoryLocation.Builder()).build());
        }

        public final Builder repositoryEphemeralId(String value) {
            this.repositoryEphemeralId = value;
            return this;
        }

        public final Builder repositoryStartedAt(String value) {
            this.repositoryStartedAt = value;
            return this;
        }

        public final Builder repositoryStoppedAt(@Nullable String value) {
            this.repositoryStoppedAt = value;
            return this;
        }

        public final Builder archived(boolean value) {
            this.archived = value;
            return this;
        }

        public final Builder clusterVersion(@Nullable Long value) {
            this.clusterVersion = value;
            return this;
        }

        public final Builder requestCounts(RequestCounts value) {
            this.requestCounts = value;
            return this;
        }

        public final Builder requestCounts(Function<RequestCounts.Builder, ObjectBuilder<RequestCounts>> fn) {
            return this.requestCounts(fn.apply(new RequestCounts.Builder()).build());
        }

        @Override
        public RepositoryMeteringInformation build() {
            this._checkSingleUse();
            return new RepositoryMeteringInformation(this);
        }
    }
}

