/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CoordinatorStats
implements JsonpSerializable {
    private final long executedSearchesTotal;
    private final String nodeId;
    private final int queueSize;
    private final int remoteRequestsCurrent;
    private final long remoteRequestsTotal;
    public static final JsonpDeserializer<CoordinatorStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CoordinatorStats::setupCoordinatorStatsDeserializer);

    private CoordinatorStats(Builder builder) {
        this.executedSearchesTotal = ApiTypeHelper.requireNonNull(builder.executedSearchesTotal, this, "executedSearchesTotal");
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.queueSize = ApiTypeHelper.requireNonNull(builder.queueSize, this, "queueSize");
        this.remoteRequestsCurrent = ApiTypeHelper.requireNonNull(builder.remoteRequestsCurrent, this, "remoteRequestsCurrent");
        this.remoteRequestsTotal = ApiTypeHelper.requireNonNull(builder.remoteRequestsTotal, this, "remoteRequestsTotal");
    }

    public static CoordinatorStats of(Function<Builder, ObjectBuilder<CoordinatorStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long executedSearchesTotal() {
        return this.executedSearchesTotal;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final int queueSize() {
        return this.queueSize;
    }

    public final int remoteRequestsCurrent() {
        return this.remoteRequestsCurrent;
    }

    public final long remoteRequestsTotal() {
        return this.remoteRequestsTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("executed_searches_total");
        generator.write(this.executedSearchesTotal);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("queue_size");
        generator.write(this.queueSize);
        generator.writeKey("remote_requests_current");
        generator.write(this.remoteRequestsCurrent);
        generator.writeKey("remote_requests_total");
        generator.write(this.remoteRequestsTotal);
    }

    protected static void setupCoordinatorStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::executedSearchesTotal, JsonpDeserializer.longDeserializer(), "executed_searches_total");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::queueSize, JsonpDeserializer.integerDeserializer(), "queue_size");
        op.add(Builder::remoteRequestsCurrent, JsonpDeserializer.integerDeserializer(), "remote_requests_current");
        op.add(Builder::remoteRequestsTotal, JsonpDeserializer.longDeserializer(), "remote_requests_total");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CoordinatorStats> {
        private Long executedSearchesTotal;
        private String nodeId;
        private Integer queueSize;
        private Integer remoteRequestsCurrent;
        private Long remoteRequestsTotal;

        public final Builder executedSearchesTotal(long value) {
            this.executedSearchesTotal = value;
            return this;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder queueSize(int value) {
            this.queueSize = value;
            return this;
        }

        public final Builder remoteRequestsCurrent(int value) {
            this.remoteRequestsCurrent = value;
            return this;
        }

        public final Builder remoteRequestsTotal(long value) {
            this.remoteRequestsTotal = value;
            return this;
        }

        @Override
        public CoordinatorStats build() {
            this._checkSingleUse();
            return new CoordinatorStats(this);
        }
    }
}

