/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.NodeStatistics;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

public abstract class NodesResponseBase
implements JsonpSerializable {
    private final NodeStatistics nodeStats;

    protected NodesResponseBase(AbstractBuilder<?> builder) {
        this.nodeStats = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).nodeStats, this, "nodeStats");
    }

    public final NodeStatistics nodeStats() {
        return this.nodeStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_nodes");
        this.nodeStats.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupNodesResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::nodeStats, NodeStatistics._DESERIALIZER, "_nodes");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        private NodeStatistics nodeStats;

        protected AbstractBuilder() {
        }

        public final BuilderT nodeStats(NodeStatistics value) {
            this.nodeStats = value;
            return this.self();
        }

        public final BuilderT nodeStats(Function<NodeStatistics.Builder, ObjectBuilder<NodeStatistics>> fn) {
            return this.nodeStats(fn.apply(new NodeStatistics.Builder()).build());
        }

        protected abstract BuilderT self();
    }
}

