/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch._types.TransformVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ChainTransform
implements TransformVariant,
JsonpSerializable {
    private final List<Transform> transforms;
    public static final JsonpDeserializer<ChainTransform> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChainTransform::setupChainTransformDeserializer);

    private ChainTransform(Builder builder) {
        this.transforms = ApiTypeHelper.unmodifiableRequired(builder.transforms, (Object)this, "transforms");
    }

    public static ChainTransform of(Function<Builder, ObjectBuilder<ChainTransform>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Transform.Kind _transformKind() {
        return Transform.Kind.Chain;
    }

    public final List<Transform> transforms() {
        return this.transforms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.transforms)) {
            generator.writeKey("transforms");
            generator.writeStartArray();
            for (Transform item0 : this.transforms) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupChainTransformDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::transforms, JsonpDeserializer.arrayDeserializer(Transform._DESERIALIZER), "transforms");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ChainTransform> {
        private List<Transform> transforms;

        public final Builder transforms(List<Transform> list) {
            this.transforms = Builder._listAddAll(this.transforms, list);
            return this;
        }

        public final Builder transforms(Transform value, Transform ... values) {
            this.transforms = Builder._listAdd(this.transforms, value, values);
            return this;
        }

        public final Builder transforms(Function<Transform.Builder, ObjectBuilder<Transform>> fn) {
            return this.transforms(fn.apply(new Transform.Builder()).build(), new Transform[0]);
        }

        @Override
        public ChainTransform build() {
            this._checkSingleUse();
            return new ChainTransform(this);
        }
    }
}

