/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.GarbageCollector;
import co.elastic.clients.elasticsearch.nodes.JvmClasses;
import co.elastic.clients.elasticsearch.nodes.JvmThreads;
import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.elasticsearch.nodes.NodeBufferPool;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class Jvm
implements JsonpSerializable {
    private final Map<String, NodeBufferPool> bufferPools;
    private final JvmClasses classes;
    private final GarbageCollector gc;
    private final MemoryStats mem;
    private final JvmThreads threads;
    private final long timestamp;
    private final String uptime;
    private final long uptimeInMillis;
    public static final JsonpDeserializer<Jvm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Jvm::setupJvmDeserializer);

    private Jvm(Builder builder) {
        this.bufferPools = ApiTypeHelper.unmodifiableRequired(builder.bufferPools, (Object)this, "bufferPools");
        this.classes = ApiTypeHelper.requireNonNull(builder.classes, this, "classes");
        this.gc = ApiTypeHelper.requireNonNull(builder.gc, this, "gc");
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.threads = ApiTypeHelper.requireNonNull(builder.threads, this, "threads");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.uptime = ApiTypeHelper.requireNonNull(builder.uptime, this, "uptime");
        this.uptimeInMillis = ApiTypeHelper.requireNonNull(builder.uptimeInMillis, this, "uptimeInMillis");
    }

    public static Jvm of(Function<Builder, ObjectBuilder<Jvm>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, NodeBufferPool> bufferPools() {
        return this.bufferPools;
    }

    public final JvmClasses classes() {
        return this.classes;
    }

    public final GarbageCollector gc() {
        return this.gc;
    }

    public final MemoryStats mem() {
        return this.mem;
    }

    public final JvmThreads threads() {
        return this.threads;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    public final String uptime() {
        return this.uptime;
    }

    public final long uptimeInMillis() {
        return this.uptimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.bufferPools)) {
            generator.writeKey("buffer_pools");
            generator.writeStartObject();
            for (Map.Entry<String, NodeBufferPool> item0 : this.bufferPools.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("classes");
        this.classes.serialize(generator, mapper);
        generator.writeKey("gc");
        this.gc.serialize(generator, mapper);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("threads");
        this.threads.serialize(generator, mapper);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        generator.writeKey("uptime");
        generator.write(this.uptime);
        generator.writeKey("uptime_in_millis");
        generator.write(this.uptimeInMillis);
    }

    protected static void setupJvmDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bufferPools, JsonpDeserializer.stringMapDeserializer(NodeBufferPool._DESERIALIZER), "buffer_pools");
        op.add(Builder::classes, JvmClasses._DESERIALIZER, "classes");
        op.add(Builder::gc, GarbageCollector._DESERIALIZER, "gc");
        op.add(Builder::mem, MemoryStats._DESERIALIZER, "mem");
        op.add(Builder::threads, JvmThreads._DESERIALIZER, "threads");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::uptime, JsonpDeserializer.stringDeserializer(), "uptime");
        op.add(Builder::uptimeInMillis, JsonpDeserializer.longDeserializer(), "uptime_in_millis");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Jvm> {
        private Map<String, NodeBufferPool> bufferPools;
        private JvmClasses classes;
        private GarbageCollector gc;
        private MemoryStats mem;
        private JvmThreads threads;
        private Long timestamp;
        private String uptime;
        private Long uptimeInMillis;

        public final Builder bufferPools(Map<String, NodeBufferPool> map) {
            this.bufferPools = Builder._mapPutAll(this.bufferPools, map);
            return this;
        }

        public final Builder bufferPools(String key, NodeBufferPool value) {
            this.bufferPools = Builder._mapPut(this.bufferPools, key, value);
            return this;
        }

        public final Builder bufferPools(String key, Function<NodeBufferPool.Builder, ObjectBuilder<NodeBufferPool>> fn) {
            return this.bufferPools(key, fn.apply(new NodeBufferPool.Builder()).build());
        }

        public final Builder classes(JvmClasses value) {
            this.classes = value;
            return this;
        }

        public final Builder classes(Function<JvmClasses.Builder, ObjectBuilder<JvmClasses>> fn) {
            return this.classes(fn.apply(new JvmClasses.Builder()).build());
        }

        public final Builder gc(GarbageCollector value) {
            this.gc = value;
            return this;
        }

        public final Builder gc(Function<GarbageCollector.Builder, ObjectBuilder<GarbageCollector>> fn) {
            return this.gc(fn.apply(new GarbageCollector.Builder()).build());
        }

        public final Builder mem(MemoryStats value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<MemoryStats.Builder, ObjectBuilder<MemoryStats>> fn) {
            return this.mem(fn.apply(new MemoryStats.Builder()).build());
        }

        public final Builder threads(JvmThreads value) {
            this.threads = value;
            return this;
        }

        public final Builder threads(Function<JvmThreads.Builder, ObjectBuilder<JvmThreads>> fn) {
            return this.threads(fn.apply(new JvmThreads.Builder()).build());
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder uptime(String value) {
            this.uptime = value;
            return this;
        }

        public final Builder uptimeInMillis(long value) {
            this.uptimeInMillis = value;
            return this;
        }

        @Override
        public Jvm build() {
            this._checkSingleUse();
            return new Jvm(this);
        }
    }
}

