/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.elasticsearch.indices.analyze.ExplainAnalyzeToken;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TokenDetail
implements JsonpSerializable {
    private final String name;
    private final List<ExplainAnalyzeToken> tokens;
    public static final JsonpDeserializer<TokenDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TokenDetail::setupTokenDetailDeserializer);

    private TokenDetail(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.tokens = ApiTypeHelper.unmodifiableRequired(builder.tokens, (Object)this, "tokens");
    }

    public static TokenDetail of(Function<Builder, ObjectBuilder<TokenDetail>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final List<ExplainAnalyzeToken> tokens() {
        return this.tokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.tokens)) {
            generator.writeKey("tokens");
            generator.writeStartArray();
            for (ExplainAnalyzeToken item0 : this.tokens) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTokenDetailDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::tokens, JsonpDeserializer.arrayDeserializer(ExplainAnalyzeToken._DESERIALIZER), "tokens");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TokenDetail> {
        private String name;
        private List<ExplainAnalyzeToken> tokens;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder tokens(List<ExplainAnalyzeToken> list) {
            this.tokens = Builder._listAddAll(this.tokens, list);
            return this;
        }

        public final Builder tokens(ExplainAnalyzeToken value, ExplainAnalyzeToken ... values) {
            this.tokens = Builder._listAdd(this.tokens, value, values);
            return this;
        }

        public final Builder tokens(Function<ExplainAnalyzeToken.Builder, ObjectBuilder<ExplainAnalyzeToken>> fn) {
            return this.tokens(fn.apply(new ExplainAnalyzeToken.Builder()).build(), new ExplainAnalyzeToken[0]);
        }

        @Override
        public TokenDetail build() {
            this._checkSingleUse();
            return new TokenDetail(this);
        }
    }
}

