/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NodeBufferPool
implements JsonpSerializable {
    private final long count;
    private final String totalCapacity;
    private final long totalCapacityInBytes;
    private final String used;
    private final long usedInBytes;
    public static final JsonpDeserializer<NodeBufferPool> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeBufferPool::setupNodeBufferPoolDeserializer);

    private NodeBufferPool(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.totalCapacity = ApiTypeHelper.requireNonNull(builder.totalCapacity, this, "totalCapacity");
        this.totalCapacityInBytes = ApiTypeHelper.requireNonNull(builder.totalCapacityInBytes, this, "totalCapacityInBytes");
        this.used = ApiTypeHelper.requireNonNull(builder.used, this, "used");
        this.usedInBytes = ApiTypeHelper.requireNonNull(builder.usedInBytes, this, "usedInBytes");
    }

    public static NodeBufferPool of(Function<Builder, ObjectBuilder<NodeBufferPool>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final String totalCapacity() {
        return this.totalCapacity;
    }

    public final long totalCapacityInBytes() {
        return this.totalCapacityInBytes;
    }

    public final String used() {
        return this.used;
    }

    public final long usedInBytes() {
        return this.usedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("total_capacity");
        generator.write(this.totalCapacity);
        generator.writeKey("total_capacity_in_bytes");
        generator.write(this.totalCapacityInBytes);
        generator.writeKey("used");
        generator.write(this.used);
        generator.writeKey("used_in_bytes");
        generator.write(this.usedInBytes);
    }

    protected static void setupNodeBufferPoolDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::totalCapacity, JsonpDeserializer.stringDeserializer(), "total_capacity");
        op.add(Builder::totalCapacityInBytes, JsonpDeserializer.longDeserializer(), "total_capacity_in_bytes");
        op.add(Builder::used, JsonpDeserializer.stringDeserializer(), "used");
        op.add(Builder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeBufferPool> {
        private Long count;
        private String totalCapacity;
        private Long totalCapacityInBytes;
        private String used;
        private Long usedInBytes;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder totalCapacity(String value) {
            this.totalCapacity = value;
            return this;
        }

        public final Builder totalCapacityInBytes(long value) {
            this.totalCapacityInBytes = value;
            return this;
        }

        public final Builder used(String value) {
            this.used = value;
            return this;
        }

        public final Builder usedInBytes(long value) {
            this.usedInBytes = value;
            return this;
        }

        @Override
        public NodeBufferPool build() {
            this._checkSingleUse();
            return new NodeBufferPool(this);
        }
    }
}

