/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Breaker
implements JsonpSerializable {
    private final String estimatedSize;
    private final long estimatedSizeInBytes;
    private final String limitSize;
    private final long limitSizeInBytes;
    private final float overhead;
    private final float tripped;
    public static final JsonpDeserializer<Breaker> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Breaker::setupBreakerDeserializer);

    private Breaker(Builder builder) {
        this.estimatedSize = ApiTypeHelper.requireNonNull(builder.estimatedSize, this, "estimatedSize");
        this.estimatedSizeInBytes = ApiTypeHelper.requireNonNull(builder.estimatedSizeInBytes, this, "estimatedSizeInBytes");
        this.limitSize = ApiTypeHelper.requireNonNull(builder.limitSize, this, "limitSize");
        this.limitSizeInBytes = ApiTypeHelper.requireNonNull(builder.limitSizeInBytes, this, "limitSizeInBytes");
        this.overhead = ApiTypeHelper.requireNonNull(builder.overhead, this, "overhead").floatValue();
        this.tripped = ApiTypeHelper.requireNonNull(builder.tripped, this, "tripped").floatValue();
    }

    public static Breaker of(Function<Builder, ObjectBuilder<Breaker>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String estimatedSize() {
        return this.estimatedSize;
    }

    public final long estimatedSizeInBytes() {
        return this.estimatedSizeInBytes;
    }

    public final String limitSize() {
        return this.limitSize;
    }

    public final long limitSizeInBytes() {
        return this.limitSizeInBytes;
    }

    public final float overhead() {
        return this.overhead;
    }

    public final float tripped() {
        return this.tripped;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("estimated_size");
        generator.write(this.estimatedSize);
        generator.writeKey("estimated_size_in_bytes");
        generator.write(this.estimatedSizeInBytes);
        generator.writeKey("limit_size");
        generator.write(this.limitSize);
        generator.writeKey("limit_size_in_bytes");
        generator.write(this.limitSizeInBytes);
        generator.writeKey("overhead");
        generator.write((double)this.overhead);
        generator.writeKey("tripped");
        generator.write((double)this.tripped);
    }

    protected static void setupBreakerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::estimatedSize, JsonpDeserializer.stringDeserializer(), "estimated_size");
        op.add(Builder::estimatedSizeInBytes, JsonpDeserializer.longDeserializer(), "estimated_size_in_bytes");
        op.add(Builder::limitSize, JsonpDeserializer.stringDeserializer(), "limit_size");
        op.add(Builder::limitSizeInBytes, JsonpDeserializer.longDeserializer(), "limit_size_in_bytes");
        op.add(Builder::overhead, JsonpDeserializer.floatDeserializer(), "overhead");
        op.add(Builder::tripped, JsonpDeserializer.floatDeserializer(), "tripped");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Breaker> {
        private String estimatedSize;
        private Long estimatedSizeInBytes;
        private String limitSize;
        private Long limitSizeInBytes;
        private Float overhead;
        private Float tripped;

        public final Builder estimatedSize(String value) {
            this.estimatedSize = value;
            return this;
        }

        public final Builder estimatedSizeInBytes(long value) {
            this.estimatedSizeInBytes = value;
            return this;
        }

        public final Builder limitSize(String value) {
            this.limitSize = value;
            return this;
        }

        public final Builder limitSizeInBytes(long value) {
            this.limitSizeInBytes = value;
            return this;
        }

        public final Builder overhead(float value) {
            this.overhead = Float.valueOf(value);
            return this;
        }

        public final Builder tripped(float value) {
            this.tripped = Float.valueOf(value);
            return this;
        }

        @Override
        public Breaker build() {
            this._checkSingleUse();
            return new Breaker(this);
        }
    }
}

