/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.license.DeleteLicenseRequest;
import co.elastic.clients.elasticsearch.license.DeleteLicenseResponse;
import co.elastic.clients.elasticsearch.license.GetBasicStatusRequest;
import co.elastic.clients.elasticsearch.license.GetBasicStatusResponse;
import co.elastic.clients.elasticsearch.license.GetLicenseRequest;
import co.elastic.clients.elasticsearch.license.GetLicenseResponse;
import co.elastic.clients.elasticsearch.license.GetTrialStatusRequest;
import co.elastic.clients.elasticsearch.license.GetTrialStatusResponse;
import co.elastic.clients.elasticsearch.license.PostRequest;
import co.elastic.clients.elasticsearch.license.PostResponse;
import co.elastic.clients.elasticsearch.license.PostStartBasicRequest;
import co.elastic.clients.elasticsearch.license.PostStartBasicResponse;
import co.elastic.clients.elasticsearch.license.PostStartTrialRequest;
import co.elastic.clients.elasticsearch.license.PostStartTrialResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchLicenseAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchLicenseAsyncClient> {
    public ElasticsearchLicenseAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchLicenseAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchLicenseAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchLicenseAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeleteLicenseResponse> delete() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(DeleteLicenseRequest._INSTANCE, DeleteLicenseRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetLicenseResponse> get(GetLicenseRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetLicenseRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetLicenseResponse> get(Function<GetLicenseRequest.Builder, ObjectBuilder<GetLicenseRequest>> fn) throws IOException, ElasticsearchException {
        return this.get(fn.apply(new GetLicenseRequest.Builder()).build());
    }

    public CompletableFuture<GetLicenseResponse> get() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetLicenseRequest.Builder().build(), GetLicenseRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetBasicStatusResponse> getBasicStatus() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(GetBasicStatusRequest._INSTANCE, GetBasicStatusRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetTrialStatusResponse> getTrialStatus() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(GetTrialStatusRequest._INSTANCE, GetTrialStatusRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<PostResponse> post(PostRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)PostRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PostResponse> post(Function<PostRequest.Builder, ObjectBuilder<PostRequest>> fn) throws IOException, ElasticsearchException {
        return this.post(fn.apply(new PostRequest.Builder()).build());
    }

    public CompletableFuture<PostResponse> post() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new PostRequest.Builder().build(), PostRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<PostStartBasicResponse> postStartBasic(PostStartBasicRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)PostStartBasicRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PostStartBasicResponse> postStartBasic(Function<PostStartBasicRequest.Builder, ObjectBuilder<PostStartBasicRequest>> fn) throws IOException, ElasticsearchException {
        return this.postStartBasic(fn.apply(new PostStartBasicRequest.Builder()).build());
    }

    public CompletableFuture<PostStartBasicResponse> postStartBasic() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new PostStartBasicRequest.Builder().build(), PostStartBasicRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<PostStartTrialResponse> postStartTrial(PostStartTrialRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)PostStartTrialRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PostStartTrialResponse> postStartTrial(Function<PostStartTrialRequest.Builder, ObjectBuilder<PostStartTrialRequest>> fn) throws IOException, ElasticsearchException {
        return this.postStartTrial(fn.apply(new PostStartTrialRequest.Builder()).build());
    }

    public CompletableFuture<PostStartTrialResponse> postStartTrial() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new PostStartTrialRequest.Builder().build(), PostStartTrialRequest._ENDPOINT, this.transportOptions);
    }
}

