/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TermSuggestOption
implements JsonpSerializable {
    private final String text;
    @Nullable
    private final Long freq;
    private final double score;
    public static final JsonpDeserializer<TermSuggestOption> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermSuggestOption::setupTermSuggestOptionDeserializer);

    private TermSuggestOption(Builder builder) {
        this.text = ApiTypeHelper.requireNonNull(builder.text, this, "text");
        this.freq = builder.freq;
        this.score = ApiTypeHelper.requireNonNull(builder.score, this, "score");
    }

    public static TermSuggestOption of(Function<Builder, ObjectBuilder<TermSuggestOption>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String text() {
        return this.text;
    }

    @Nullable
    public final Long freq() {
        return this.freq;
    }

    public final double score() {
        return this.score;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("text");
        generator.write(this.text);
        if (this.freq != null) {
            generator.writeKey("freq");
            generator.write(this.freq.longValue());
        }
        generator.writeKey("score");
        generator.write(this.score);
    }

    protected static void setupTermSuggestOptionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.add(Builder::freq, JsonpDeserializer.longDeserializer(), "freq");
        op.add(Builder::score, JsonpDeserializer.doubleDeserializer(), "score");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TermSuggestOption> {
        private String text;
        @Nullable
        private Long freq;
        private Double score;

        public final Builder text(String value) {
            this.text = value;
            return this;
        }

        public final Builder freq(@Nullable Long value) {
            this.freq = value;
            return this;
        }

        public final Builder score(double value) {
            this.score = value;
            return this;
        }

        @Override
        public TermSuggestOption build() {
            this._checkSingleUse();
            return new TermSuggestOption(this);
        }
    }
}

