/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.WaitForActiveShards;
import co.elastic.clients.elasticsearch.core.UpdateResponse;
import co.elastic.clients.elasticsearch.core.search.SourceConfig;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class UpdateRequest<TDocument, TPartialDocument>
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final SourceConfig source;
    @Nullable
    private final Boolean detectNoop;
    @Nullable
    private final TPartialDocument doc;
    @Nullable
    private final Boolean docAsUpsert;
    private final String id;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Long ifSeqNo;
    private final String index;
    @Nullable
    private final String lang;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final Integer retryOnConflict;
    @Nullable
    private final String routing;
    @Nullable
    private final Script script;
    @Nullable
    private final Boolean scriptedUpsert;
    @Nullable
    private final Time timeout;
    @Nullable
    private final String type;
    @Nullable
    private final TDocument upsert;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    @Nullable
    private final JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;
    public static final SimpleEndpoint<UpdateRequest<?, ?>, ?> _ENDPOINT = new SimpleEndpoint<UpdateRequest, UpdateResponse<Object>>("es/update", request -> "POST", request -> {
        boolean _index = true;
        int _id = 2;
        int _type = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_update");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.lang != null) {
            params.put("lang", request.lang);
        }
        if (request.retryOnConflict != null) {
            params.put("retry_on_conflict", String.valueOf(request.retryOnConflict));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, UpdateResponse._DESERIALIZER);

    private UpdateRequest(Builder<TDocument, TPartialDocument> builder) {
        this.source = ((Builder)builder).source;
        this.detectNoop = ((Builder)builder).detectNoop;
        this.doc = ((Builder)builder).doc;
        this.docAsUpsert = ((Builder)builder).docAsUpsert;
        this.id = ApiTypeHelper.requireNonNull(((Builder)builder).id, this, "id");
        this.ifPrimaryTerm = ((Builder)builder).ifPrimaryTerm;
        this.ifSeqNo = ((Builder)builder).ifSeqNo;
        this.index = ApiTypeHelper.requireNonNull(((Builder)builder).index, this, "index");
        this.lang = ((Builder)builder).lang;
        this.refresh = ((Builder)builder).refresh;
        this.requireAlias = ((Builder)builder).requireAlias;
        this.retryOnConflict = ((Builder)builder).retryOnConflict;
        this.routing = ((Builder)builder).routing;
        this.script = ((Builder)builder).script;
        this.scriptedUpsert = ((Builder)builder).scriptedUpsert;
        this.timeout = ((Builder)builder).timeout;
        this.type = ((Builder)builder).type;
        this.upsert = ((Builder)builder).upsert;
        this.waitForActiveShards = ((Builder)builder).waitForActiveShards;
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
        this.tPartialDocumentSerializer = ((Builder)builder).tPartialDocumentSerializer;
    }

    public static <TDocument, TPartialDocument> UpdateRequest<TDocument, TPartialDocument> of(Function<Builder<TDocument, TPartialDocument>, ObjectBuilder<UpdateRequest<TDocument, TPartialDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final SourceConfig source() {
        return this.source;
    }

    @Nullable
    public final Boolean detectNoop() {
        return this.detectNoop;
    }

    @Nullable
    public final TPartialDocument doc() {
        return this.doc;
    }

    @Nullable
    public final Boolean docAsUpsert() {
        return this.docAsUpsert;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public final Long ifSeqNo() {
        return this.ifSeqNo;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final String lang() {
        return this.lang;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public final Integer retryOnConflict() {
        return this.retryOnConflict;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Boolean scriptedUpsert() {
        return this.scriptedUpsert;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Nullable
    public final TDocument upsert() {
        return this.upsert;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (this.detectNoop != null) {
            generator.writeKey("detect_noop");
            generator.write(this.detectNoop.booleanValue());
        }
        if (this.doc != null) {
            generator.writeKey("doc");
            JsonpUtils.serialize(this.doc, generator, this.tPartialDocumentSerializer, mapper);
        }
        if (this.docAsUpsert != null) {
            generator.writeKey("doc_as_upsert");
            generator.write(this.docAsUpsert.booleanValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.scriptedUpsert != null) {
            generator.writeKey("scripted_upsert");
            generator.write(this.scriptedUpsert.booleanValue());
        }
        if (this.upsert != null) {
            generator.writeKey("upsert");
            JsonpUtils.serialize(this.upsert, generator, this.tDocumentSerializer, mapper);
        }
    }

    public static <TDocument, TPartialDocument> JsonpDeserializer<UpdateRequest<TDocument, TPartialDocument>> createUpdateRequestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer, JsonpDeserializer<TPartialDocument> tPartialDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> UpdateRequest.setupUpdateRequestDeserializer(op, tDocumentDeserializer, tPartialDocumentDeserializer));
    }

    protected static <TDocument, TPartialDocument> void setupUpdateRequestDeserializer(ObjectDeserializer<Builder<TDocument, TPartialDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer, JsonpDeserializer<TPartialDocument> tPartialDocumentDeserializer) {
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::detectNoop, JsonpDeserializer.booleanDeserializer(), "detect_noop");
        op.add(Builder::doc, tPartialDocumentDeserializer, "doc");
        op.add(Builder::docAsUpsert, JsonpDeserializer.booleanDeserializer(), "doc_as_upsert");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::scriptedUpsert, JsonpDeserializer.booleanDeserializer(), "scripted_upsert");
        op.add(Builder::upsert, tDocumentDeserializer, "upsert");
    }

    public static <TDocument> Endpoint<UpdateRequest<?, ?>, UpdateResponse<TDocument>, ErrorResponse> createUpdateEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(UpdateResponse.createUpdateResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder<TDocument, TPartialDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<UpdateRequest<TDocument, TPartialDocument>> {
        @Nullable
        private SourceConfig source;
        @Nullable
        private Boolean detectNoop;
        @Nullable
        private TPartialDocument doc;
        @Nullable
        private Boolean docAsUpsert;
        private String id;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Long ifSeqNo;
        private String index;
        @Nullable
        private String lang;
        @Nullable
        private Refresh refresh;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private Integer retryOnConflict;
        @Nullable
        private String routing;
        @Nullable
        private Script script;
        @Nullable
        private Boolean scriptedUpsert;
        @Nullable
        private Time timeout;
        @Nullable
        private String type;
        @Nullable
        private TDocument upsert;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;
        @Nullable
        private JsonpSerializer<TPartialDocument> tPartialDocumentSerializer;

        public final Builder<TDocument, TPartialDocument> source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> detectNoop(@Nullable Boolean value) {
            this.detectNoop = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> doc(@Nullable TPartialDocument value) {
            this.doc = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> docAsUpsert(@Nullable Boolean value) {
            this.docAsUpsert = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> id(String value) {
            this.id = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> ifSeqNo(@Nullable Long value) {
            this.ifSeqNo = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> lang(@Nullable String value) {
            this.lang = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> retryOnConflict(@Nullable Integer value) {
            this.retryOnConflict = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> scriptedUpsert(@Nullable Boolean value) {
            this.scriptedUpsert = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> upsert(@Nullable TDocument value) {
            this.upsert = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        public final Builder<TDocument, TPartialDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        public final Builder<TDocument, TPartialDocument> tPartialDocumentSerializer(@Nullable JsonpSerializer<TPartialDocument> value) {
            this.tPartialDocumentSerializer = value;
            return this;
        }

        @Override
        public UpdateRequest<TDocument, TPartialDocument> build() {
            this._checkSingleUse();
            return new UpdateRequest(this);
        }
    }
}

