/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Monitoring
extends Base {
    private final boolean collectionEnabled;
    private final Map<String, Long> enabledExporters;
    public static final JsonpDeserializer<Monitoring> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Monitoring::setupMonitoringDeserializer, Builder::build);

    public Monitoring(Builder builder) {
        super(builder);
        this.collectionEnabled = Objects.requireNonNull(builder.collectionEnabled, "collection_enabled");
        this.enabledExporters = ModelTypeHelper.unmodifiableNonNull(builder.enabledExporters, "enabled_exporters");
    }

    public Monitoring(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean collectionEnabled() {
        return this.collectionEnabled;
    }

    public Map<String, Long> enabledExporters() {
        return this.enabledExporters;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("collection_enabled");
        generator.write(this.collectionEnabled);
        generator.writeKey("enabled_exporters");
        generator.writeStartObject();
        for (Map.Entry<String, Long> item0 : this.enabledExporters.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue().longValue());
        }
        generator.writeEnd();
    }

    protected static void setupMonitoringDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::collectionEnabled, JsonpDeserializer.booleanDeserializer(), "collection_enabled", new String[0]);
        op.add(Builder::enabledExporters, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "enabled_exporters", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Monitoring> {
        private Boolean collectionEnabled;
        private Map<String, Long> enabledExporters;

        public Builder collectionEnabled(boolean value) {
            this.collectionEnabled = value;
            return this;
        }

        public Builder enabledExporters(Map<String, Long> value) {
            this.enabledExporters = value;
            return this;
        }

        public Builder putEnabledExporters(String key, Long value) {
            if (this.enabledExporters == null) {
                this.enabledExporters = new HashMap<String, Long>();
            }
            this.enabledExporters.put(key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Monitoring build() {
            return new Monitoring(this);
        }
    }
}

