/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.IlmPolicyStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Ilm
implements JsonpSerializable {
    private final int policyCount;
    private final List<IlmPolicyStatistics> policyStats;
    public static final JsonpDeserializer<Ilm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ilm::setupIlmDeserializer, Builder::build);

    public Ilm(Builder builder) {
        this.policyCount = Objects.requireNonNull(builder.policyCount, "policy_count");
        this.policyStats = ModelTypeHelper.unmodifiableNonNull(builder.policyStats, "policy_stats");
    }

    public Ilm(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int policyCount() {
        return this.policyCount;
    }

    public List<IlmPolicyStatistics> policyStats() {
        return this.policyStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("policy_count");
        generator.write(this.policyCount);
        generator.writeKey("policy_stats");
        generator.writeStartArray();
        for (IlmPolicyStatistics item0 : this.policyStats) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupIlmDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::policyCount, JsonpDeserializer.integerDeserializer(), "policy_count", new String[0]);
        op.add(Builder::policyStats, JsonpDeserializer.arrayDeserializer(IlmPolicyStatistics._DESERIALIZER), "policy_stats", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Ilm> {
        private Integer policyCount;
        private List<IlmPolicyStatistics> policyStats;

        public Builder policyCount(int value) {
            this.policyCount = value;
            return this;
        }

        public Builder policyStats(List<IlmPolicyStatistics> value) {
            this.policyStats = value;
            return this;
        }

        public Builder policyStats(IlmPolicyStatistics ... value) {
            this.policyStats = Arrays.asList(value);
            return this;
        }

        public Builder addPolicyStats(IlmPolicyStatistics value) {
            if (this.policyStats == null) {
                this.policyStats = new ArrayList<IlmPolicyStatistics>();
            }
            this.policyStats.add(value);
            return this;
        }

        public Builder policyStats(Function<IlmPolicyStatistics.Builder, ObjectBuilder<IlmPolicyStatistics>> fn) {
            return this.policyStats(fn.apply(new IlmPolicyStatistics.Builder()).build());
        }

        public Builder addPolicyStats(Function<IlmPolicyStatistics.Builder, ObjectBuilder<IlmPolicyStatistics>> fn) {
            return this.addPolicyStats(fn.apply(new IlmPolicyStatistics.Builder()).build());
        }

        @Override
        public Ilm build() {
            return new Ilm(this);
        }
    }
}

