/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Ccr
extends Base {
    private final int autoFollowPatternsCount;
    private final int followerIndicesCount;
    public static final JsonpDeserializer<Ccr> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Ccr::setupCcrDeserializer, Builder::build);

    public Ccr(Builder builder) {
        super(builder);
        this.autoFollowPatternsCount = Objects.requireNonNull(builder.autoFollowPatternsCount, "auto_follow_patterns_count");
        this.followerIndicesCount = Objects.requireNonNull(builder.followerIndicesCount, "follower_indices_count");
    }

    public Ccr(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int autoFollowPatternsCount() {
        return this.autoFollowPatternsCount;
    }

    public int followerIndicesCount() {
        return this.followerIndicesCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("auto_follow_patterns_count");
        generator.write(this.autoFollowPatternsCount);
        generator.writeKey("follower_indices_count");
        generator.write(this.followerIndicesCount);
    }

    protected static void setupCcrDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::autoFollowPatternsCount, JsonpDeserializer.integerDeserializer(), "auto_follow_patterns_count", new String[0]);
        op.add(Builder::followerIndicesCount, JsonpDeserializer.integerDeserializer(), "follower_indices_count", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Ccr> {
        private Integer autoFollowPatternsCount;
        private Integer followerIndicesCount;

        public Builder autoFollowPatternsCount(int value) {
            this.autoFollowPatternsCount = value;
            return this;
        }

        public Builder followerIndicesCount(int value) {
            this.followerIndicesCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Ccr build() {
            return new Ccr(this);
        }
    }
}

