/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.info;

import co.elastic.clients.elasticsearch.license.LicenseStatus;
import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class MinimalLicenseInformation
implements JsonpSerializable {
    private final String expiryDateInMillis;
    private final LicenseType mode;
    private final LicenseStatus status;
    private final LicenseType type;
    private final String uid;
    public static final JsonpDeserializer<MinimalLicenseInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MinimalLicenseInformation::setupMinimalLicenseInformationDeserializer, Builder::build);

    public MinimalLicenseInformation(Builder builder) {
        this.expiryDateInMillis = Objects.requireNonNull(builder.expiryDateInMillis, "expiry_date_in_millis");
        this.mode = Objects.requireNonNull(builder.mode, "mode");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.uid = Objects.requireNonNull(builder.uid, "uid");
    }

    public MinimalLicenseInformation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String expiryDateInMillis() {
        return this.expiryDateInMillis;
    }

    public LicenseType mode() {
        return this.mode;
    }

    public LicenseStatus status() {
        return this.status;
    }

    public LicenseType type() {
        return this.type;
    }

    public String uid() {
        return this.uid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expiry_date_in_millis");
        generator.write(this.expiryDateInMillis);
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        generator.writeKey("status");
        this.status.serialize(generator, mapper);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("uid");
        generator.write(this.uid);
    }

    protected static void setupMinimalLicenseInformationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::expiryDateInMillis, JsonpDeserializer.stringDeserializer(), "expiry_date_in_millis", new String[0]);
        op.add(Builder::mode, LicenseType._DESERIALIZER, "mode", new String[0]);
        op.add(Builder::status, LicenseStatus._DESERIALIZER, "status", new String[0]);
        op.add(Builder::type, LicenseType._DESERIALIZER, "type", new String[0]);
        op.add(Builder::uid, JsonpDeserializer.stringDeserializer(), "uid", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MinimalLicenseInformation> {
        private String expiryDateInMillis;
        private LicenseType mode;
        private LicenseStatus status;
        private LicenseType type;
        private String uid;

        public Builder expiryDateInMillis(String value) {
            this.expiryDateInMillis = value;
            return this;
        }

        public Builder mode(LicenseType value) {
            this.mode = value;
            return this;
        }

        public Builder status(LicenseStatus value) {
            this.status = value;
            return this;
        }

        public Builder type(LicenseType value) {
            this.type = value;
            return this;
        }

        public Builder uid(String value) {
            this.uid = value;
            return this;
        }

        @Override
        public MinimalLicenseInformation build() {
            return new MinimalLicenseInformation(this);
        }
    }
}

