/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack;

import co.elastic.clients.elasticsearch.xpack.info.BuildInformation;
import co.elastic.clients.elasticsearch.xpack.info.Features;
import co.elastic.clients.elasticsearch.xpack.info.MinimalLicenseInformation;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class XpackInfoResponse
implements JsonpSerializable {
    private final BuildInformation build;
    private final Features features;
    private final MinimalLicenseInformation license;
    private final String tagline;
    public static final JsonpDeserializer<XpackInfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, XpackInfoResponse::setupXpackInfoResponseDeserializer, Builder::build);

    public XpackInfoResponse(Builder builder) {
        this.build = Objects.requireNonNull(builder.build, "build");
        this.features = Objects.requireNonNull(builder.features, "features");
        this.license = Objects.requireNonNull(builder.license, "license");
        this.tagline = Objects.requireNonNull(builder.tagline, "tagline");
    }

    public XpackInfoResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public BuildInformation build() {
        return this.build;
    }

    public Features features() {
        return this.features;
    }

    public MinimalLicenseInformation license() {
        return this.license;
    }

    public String tagline() {
        return this.tagline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build");
        this.build.serialize(generator, mapper);
        generator.writeKey("features");
        this.features.serialize(generator, mapper);
        generator.writeKey("license");
        this.license.serialize(generator, mapper);
        generator.writeKey("tagline");
        generator.write(this.tagline);
    }

    protected static void setupXpackInfoResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::build, BuildInformation._DESERIALIZER, "build", new String[0]);
        op.add(Builder::features, Features._DESERIALIZER, "features", new String[0]);
        op.add(Builder::license, MinimalLicenseInformation._DESERIALIZER, "license", new String[0]);
        op.add(Builder::tagline, JsonpDeserializer.stringDeserializer(), "tagline", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<XpackInfoResponse> {
        private BuildInformation build;
        private Features features;
        private MinimalLicenseInformation license;
        private String tagline;

        public Builder build(BuildInformation value) {
            this.build = value;
            return this;
        }

        public Builder build(Function<BuildInformation.Builder, ObjectBuilder<BuildInformation>> fn) {
            return this.build(fn.apply(new BuildInformation.Builder()).build());
        }

        public Builder features(Features value) {
            this.features = value;
            return this;
        }

        public Builder features(Function<Features.Builder, ObjectBuilder<Features>> fn) {
            return this.features(fn.apply(new Features.Builder()).build());
        }

        public Builder license(MinimalLicenseInformation value) {
            this.license = value;
            return this;
        }

        public Builder license(Function<MinimalLicenseInformation.Builder, ObjectBuilder<MinimalLicenseInformation>> fn) {
            return this.license(fn.apply(new MinimalLicenseInformation.Builder()).build());
        }

        public Builder tagline(String value) {
            this.tagline = value;
            return this;
        }

        @Override
        public XpackInfoResponse build() {
            return new XpackInfoResponse(this);
        }
    }
}

