/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher.stats;

import co.elastic.clients.elasticsearch.watcher.ExecutionPhase;
import co.elastic.clients.elasticsearch.watcher.stats.WatchRecordQueuedStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class WatchRecordStats
extends WatchRecordQueuedStats {
    private final ExecutionPhase executionPhase;
    private final String triggeredTime;
    @Nullable
    private final List<String> executedActions;
    private final String watchId;
    private final String watchRecordId;
    public static final JsonpDeserializer<WatchRecordStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatchRecordStats::setupWatchRecordStatsDeserializer, Builder::build);

    public WatchRecordStats(Builder builder) {
        super(builder);
        this.executionPhase = Objects.requireNonNull(builder.executionPhase, "execution_phase");
        this.triggeredTime = Objects.requireNonNull(builder.triggeredTime, "triggered_time");
        this.executedActions = ModelTypeHelper.unmodifiable(builder.executedActions);
        this.watchId = Objects.requireNonNull(builder.watchId, "watch_id");
        this.watchRecordId = Objects.requireNonNull(builder.watchRecordId, "watch_record_id");
    }

    public WatchRecordStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ExecutionPhase executionPhase() {
        return this.executionPhase;
    }

    public String triggeredTime() {
        return this.triggeredTime;
    }

    @Nullable
    public List<String> executedActions() {
        return this.executedActions;
    }

    public String watchId() {
        return this.watchId;
    }

    public String watchRecordId() {
        return this.watchRecordId;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("execution_phase");
        this.executionPhase.serialize(generator, mapper);
        generator.writeKey("triggered_time");
        generator.write(this.triggeredTime);
        if (this.executedActions != null) {
            generator.writeKey("executed_actions");
            generator.writeStartArray();
            for (String item0 : this.executedActions) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("watch_id");
        generator.write(this.watchId);
        generator.writeKey("watch_record_id");
        generator.write(this.watchRecordId);
    }

    protected static void setupWatchRecordStatsDeserializer(DelegatingDeserializer<Builder> op) {
        WatchRecordQueuedStats.setupWatchRecordQueuedStatsDeserializer(op);
        op.add(Builder::executionPhase, ExecutionPhase._DESERIALIZER, "execution_phase", new String[0]);
        op.add(Builder::triggeredTime, JsonpDeserializer.stringDeserializer(), "triggered_time", new String[0]);
        op.add(Builder::executedActions, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "executed_actions", new String[0]);
        op.add(Builder::watchId, JsonpDeserializer.stringDeserializer(), "watch_id", new String[0]);
        op.add(Builder::watchRecordId, JsonpDeserializer.stringDeserializer(), "watch_record_id", new String[0]);
    }

    public static class Builder
    extends WatchRecordQueuedStats.AbstractBuilder<Builder>
    implements ObjectBuilder<WatchRecordStats> {
        private ExecutionPhase executionPhase;
        private String triggeredTime;
        @Nullable
        private List<String> executedActions;
        private String watchId;
        private String watchRecordId;

        public Builder executionPhase(ExecutionPhase value) {
            this.executionPhase = value;
            return this;
        }

        public Builder triggeredTime(String value) {
            this.triggeredTime = value;
            return this;
        }

        public Builder executedActions(@Nullable List<String> value) {
            this.executedActions = value;
            return this;
        }

        public Builder executedActions(String ... value) {
            this.executedActions = Arrays.asList(value);
            return this;
        }

        public Builder addExecutedActions(String value) {
            if (this.executedActions == null) {
                this.executedActions = new ArrayList<String>();
            }
            this.executedActions.add(value);
            return this;
        }

        public Builder watchId(String value) {
            this.watchId = value;
            return this;
        }

        public Builder watchRecordId(String value) {
            this.watchRecordId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatchRecordStats build() {
            return new WatchRecordStats(this);
        }
    }
}

