/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ActionStatus;
import co.elastic.clients.elasticsearch.watcher.ActivationState;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class WatchStatus
implements JsonpSerializable {
    private final Map<String, ActionStatus> actions;
    @Nullable
    private final String lastChecked;
    @Nullable
    private final String lastMetCondition;
    private final ActivationState state;
    private final long version;
    @Nullable
    private final String executionState;
    public static final JsonpDeserializer<WatchStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatchStatus::setupWatchStatusDeserializer, Builder::build);

    public WatchStatus(Builder builder) {
        this.actions = ModelTypeHelper.unmodifiableNonNull(builder.actions, "actions");
        this.lastChecked = builder.lastChecked;
        this.lastMetCondition = builder.lastMetCondition;
        this.state = Objects.requireNonNull(builder.state, "state");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.executionState = builder.executionState;
    }

    public WatchStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, ActionStatus> actions() {
        return this.actions;
    }

    @Nullable
    public String lastChecked() {
        return this.lastChecked;
    }

    @Nullable
    public String lastMetCondition() {
        return this.lastMetCondition;
    }

    public ActivationState state() {
        return this.state;
    }

    public long version() {
        return this.version;
    }

    @Nullable
    public String executionState() {
        return this.executionState;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actions");
        generator.writeStartObject();
        for (Map.Entry<String, ActionStatus> item0 : this.actions.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.lastChecked != null) {
            generator.writeKey("last_checked");
            generator.write(this.lastChecked);
        }
        if (this.lastMetCondition != null) {
            generator.writeKey("last_met_condition");
            generator.write(this.lastMetCondition);
        }
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
        if (this.executionState != null) {
            generator.writeKey("execution_state");
            generator.write(this.executionState);
        }
    }

    protected static void setupWatchStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(ActionStatus._DESERIALIZER), "actions", new String[0]);
        op.add(Builder::lastChecked, JsonpDeserializer.stringDeserializer(), "last_checked", new String[0]);
        op.add(Builder::lastMetCondition, JsonpDeserializer.stringDeserializer(), "last_met_condition", new String[0]);
        op.add(Builder::state, ActivationState._DESERIALIZER, "state", new String[0]);
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version", new String[0]);
        op.add(Builder::executionState, JsonpDeserializer.stringDeserializer(), "execution_state", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<WatchStatus> {
        private Map<String, ActionStatus> actions;
        @Nullable
        private String lastChecked;
        @Nullable
        private String lastMetCondition;
        private ActivationState state;
        private Long version;
        @Nullable
        private String executionState;

        public Builder actions(Map<String, ActionStatus> value) {
            this.actions = value;
            return this;
        }

        public Builder putActions(String key, ActionStatus value) {
            if (this.actions == null) {
                this.actions = new HashMap<String, ActionStatus>();
            }
            this.actions.put(key, value);
            return this;
        }

        public Builder actions(String key, Function<ActionStatus.Builder, ObjectBuilder<ActionStatus>> fn) {
            return this.actions(Collections.singletonMap(key, fn.apply(new ActionStatus.Builder()).build()));
        }

        public Builder putActions(String key, Function<ActionStatus.Builder, ObjectBuilder<ActionStatus>> fn) {
            return this.putActions(key, fn.apply(new ActionStatus.Builder()).build());
        }

        public Builder lastChecked(@Nullable String value) {
            this.lastChecked = value;
            return this;
        }

        public Builder lastMetCondition(@Nullable String value) {
            this.lastMetCondition = value;
            return this;
        }

        public Builder state(ActivationState value) {
            this.state = value;
            return this;
        }

        public Builder state(Function<ActivationState.Builder, ObjectBuilder<ActivationState>> fn) {
            return this.state(fn.apply(new ActivationState.Builder()).build());
        }

        public Builder version(long value) {
            this.version = value;
            return this;
        }

        public Builder executionState(@Nullable String value) {
            this.executionState = value;
            return this;
        }

        @Override
        public WatchStatus build() {
            return new WatchStatus(this);
        }
    }
}

