/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.ConditionVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ScriptCondition
implements ConditionVariant,
JsonpSerializable {
    private final String lang;
    @Nullable
    private final Map<String, JsonData> params;
    private final String source;
    public static final JsonpDeserializer<ScriptCondition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptCondition::setupScriptConditionDeserializer, Builder::build);

    public ScriptCondition(Builder builder) {
        this.lang = Objects.requireNonNull(builder.lang, "lang");
        this.params = ModelTypeHelper.unmodifiable(builder.params);
        this.source = Objects.requireNonNull(builder.source, "source");
    }

    public ScriptCondition(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "script";
    }

    public String lang() {
        return this.lang;
    }

    @Nullable
    public Map<String, JsonData> params() {
        return this.params;
    }

    public String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("lang");
        generator.write(this.lang);
        if (this.params != null) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("source");
        generator.write(this.source);
    }

    protected static void setupScriptConditionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang", new String[0]);
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params", new String[0]);
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ScriptCondition> {
        private String lang;
        @Nullable
        private Map<String, JsonData> params;
        private String source;

        public Builder lang(String value) {
            this.lang = value;
            return this;
        }

        public Builder params(@Nullable Map<String, JsonData> value) {
            this.params = value;
            return this;
        }

        public Builder putParams(String key, JsonData value) {
            if (this.params == null) {
                this.params = new HashMap<String, JsonData>();
            }
            this.params.put(key, value);
            return this;
        }

        public Builder source(String value) {
            this.source = value;
            return this;
        }

        @Override
        public ScriptCondition build() {
            return new ScriptCondition(this);
        }
    }
}

