/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class LoggingResult
implements JsonpSerializable {
    private final String loggedText;
    public static final JsonpDeserializer<LoggingResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LoggingResult::setupLoggingResultDeserializer, Builder::build);

    public LoggingResult(Builder builder) {
        this.loggedText = Objects.requireNonNull(builder.loggedText, "logged_text");
    }

    public LoggingResult(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String loggedText() {
        return this.loggedText;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("logged_text");
        generator.write(this.loggedText);
    }

    protected static void setupLoggingResultDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::loggedText, JsonpDeserializer.stringDeserializer(), "logged_text", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<LoggingResult> {
        private String loggedText;

        public Builder loggedText(String value) {
            this.loggedText = value;
            return this;
        }

        @Override
        public LoggingResult build() {
            return new LoggingResult(this);
        }
    }
}

