/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class HttpInputProxy
implements JsonpSerializable {
    private final String host;
    private final Number port;
    public static final JsonpDeserializer<HttpInputProxy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpInputProxy::setupHttpInputProxyDeserializer, Builder::build);

    public HttpInputProxy(Builder builder) {
        this.host = Objects.requireNonNull(builder.host, "host");
        this.port = Objects.requireNonNull(builder.port, "port");
    }

    public HttpInputProxy(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String host() {
        return this.host;
    }

    public Number port() {
        return this.port;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("host");
        generator.write(this.host);
        generator.writeKey("port");
        generator.write(this.port.doubleValue());
    }

    protected static void setupHttpInputProxyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host", new String[0]);
        op.add(Builder::port, JsonpDeserializer.numberDeserializer(), "port", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<HttpInputProxy> {
        private String host;
        private Number port;

        public Builder host(String value) {
            this.host = value;
            return this;
        }

        public Builder port(Number value) {
            this.port = value;
            return this;
        }

        @Override
        public HttpInputProxy build() {
            return new HttpInputProxy(this);
        }
    }
}

