/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.elasticsearch.transform.get_transform_stats.TransformProgress;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CheckpointStats
implements JsonpSerializable {
    private final long checkpoint;
    @Nullable
    private final TransformProgress checkpointProgress;
    @Nullable
    private final String timestamp;
    private final String timestampMillis;
    @Nullable
    private final String timeUpperBound;
    @Nullable
    private final String timeUpperBoundMillis;
    public static final JsonpDeserializer<CheckpointStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CheckpointStats::setupCheckpointStatsDeserializer, Builder::build);

    public CheckpointStats(Builder builder) {
        this.checkpoint = Objects.requireNonNull(builder.checkpoint, "checkpoint");
        this.checkpointProgress = builder.checkpointProgress;
        this.timestamp = builder.timestamp;
        this.timestampMillis = Objects.requireNonNull(builder.timestampMillis, "timestamp_millis");
        this.timeUpperBound = builder.timeUpperBound;
        this.timeUpperBoundMillis = builder.timeUpperBoundMillis;
    }

    public CheckpointStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long checkpoint() {
        return this.checkpoint;
    }

    @Nullable
    public TransformProgress checkpointProgress() {
        return this.checkpointProgress;
    }

    @Nullable
    public String timestamp() {
        return this.timestamp;
    }

    public String timestampMillis() {
        return this.timestampMillis;
    }

    @Nullable
    public String timeUpperBound() {
        return this.timeUpperBound;
    }

    @Nullable
    public String timeUpperBoundMillis() {
        return this.timeUpperBoundMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("checkpoint");
        generator.write(this.checkpoint);
        if (this.checkpointProgress != null) {
            generator.writeKey("checkpoint_progress");
            this.checkpointProgress.serialize(generator, mapper);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp);
        }
        generator.writeKey("timestamp_millis");
        generator.write(this.timestampMillis);
        if (this.timeUpperBound != null) {
            generator.writeKey("time_upper_bound");
            generator.write(this.timeUpperBound);
        }
        if (this.timeUpperBoundMillis != null) {
            generator.writeKey("time_upper_bound_millis");
            generator.write(this.timeUpperBoundMillis);
        }
    }

    protected static void setupCheckpointStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::checkpoint, JsonpDeserializer.longDeserializer(), "checkpoint", new String[0]);
        op.add(Builder::checkpointProgress, TransformProgress._DESERIALIZER, "checkpoint_progress", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
        op.add(Builder::timestampMillis, JsonpDeserializer.stringDeserializer(), "timestamp_millis", new String[0]);
        op.add(Builder::timeUpperBound, JsonpDeserializer.stringDeserializer(), "time_upper_bound", new String[0]);
        op.add(Builder::timeUpperBoundMillis, JsonpDeserializer.stringDeserializer(), "time_upper_bound_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CheckpointStats> {
        private Long checkpoint;
        @Nullable
        private TransformProgress checkpointProgress;
        @Nullable
        private String timestamp;
        private String timestampMillis;
        @Nullable
        private String timeUpperBound;
        @Nullable
        private String timeUpperBoundMillis;

        public Builder checkpoint(long value) {
            this.checkpoint = value;
            return this;
        }

        public Builder checkpointProgress(@Nullable TransformProgress value) {
            this.checkpointProgress = value;
            return this;
        }

        public Builder checkpointProgress(Function<TransformProgress.Builder, ObjectBuilder<TransformProgress>> fn) {
            return this.checkpointProgress(fn.apply(new TransformProgress.Builder()).build());
        }

        public Builder timestamp(@Nullable String value) {
            this.timestamp = value;
            return this;
        }

        public Builder timestampMillis(String value) {
            this.timestampMillis = value;
            return this;
        }

        public Builder timeUpperBound(@Nullable String value) {
            this.timeUpperBound = value;
            return this;
        }

        public Builder timeUpperBoundMillis(@Nullable String value) {
            this.timeUpperBoundMillis = value;
            return this;
        }

        @Override
        public CheckpointStats build() {
            return new CheckpointStats(this);
        }
    }
}

