/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.transform.PutTransformRequest;
import co.elastic.clients.elasticsearch.transform.UpdateTransformResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class UpdateTransformRequest
extends PutTransformRequest {
    @Nullable
    private final String transformId;
    public static final JsonpDeserializer<UpdateTransformRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateTransformRequest::setupUpdateTransformRequestDeserializer, Builder::build);
    public static final Endpoint<UpdateTransformRequest, UpdateTransformResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<UpdateTransformRequest, UpdateTransformResponse>(request -> "POST", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (request.transformId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateTransformResponse._DESERIALIZER);

    public UpdateTransformRequest(Builder builder) {
        super(builder);
        this.transformId = builder.transformId;
    }

    public UpdateTransformRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    @Nullable
    public String transformId() {
        return this.transformId;
    }

    protected static void setupUpdateTransformRequestDeserializer(DelegatingDeserializer<Builder> op) {
        PutTransformRequest.setupPutTransformRequestDeserializer(op);
    }

    public static class Builder
    extends PutTransformRequest.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateTransformRequest> {
        @Nullable
        private String transformId;

        @Override
        public Builder transformId(@Nullable String value) {
            this.transformId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateTransformRequest build() {
            return new UpdateTransformRequest(this);
        }
    }
}

