/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.transform.RetentionPolicyVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TimeRetentionPolicy
implements RetentionPolicyVariant,
JsonpSerializable {
    private final String field;
    private final String maxAge;
    public static final JsonpDeserializer<TimeRetentionPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TimeRetentionPolicy::setupTimeRetentionPolicyDeserializer, Builder::build);

    public TimeRetentionPolicy(Builder builder) {
        this.field = Objects.requireNonNull(builder.field, "field");
        this.maxAge = Objects.requireNonNull(builder.maxAge, "max_age");
    }

    public TimeRetentionPolicy(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "time";
    }

    public String field() {
        return this.field;
    }

    public String maxAge() {
        return this.maxAge;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("max_age");
        generator.write(this.maxAge);
    }

    protected static void setupTimeRetentionPolicyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::maxAge, JsonpDeserializer.stringDeserializer(), "max_age", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TimeRetentionPolicy> {
        private String field;
        private String maxAge;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder maxAge(String value) {
            this.maxAge = value;
            return this;
        }

        @Override
        public TimeRetentionPolicy build() {
            return new TimeRetentionPolicy(this);
        }
    }
}

