/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.transform.StartTransformResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class StartTransformRequest
extends RequestBase {
    private final String transformId;
    @Nullable
    private final String timeout;
    public static final Endpoint<StartTransformRequest, StartTransformResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StartTransformRequest, StartTransformResponse>(request -> "POST", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            buf.append("/_start");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StartTransformResponse._DESERIALIZER);

    public StartTransformRequest(Builder builder) {
        this.transformId = Objects.requireNonNull(builder.transformId, "transform_id");
        this.timeout = builder.timeout;
    }

    public StartTransformRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String transformId() {
        return this.transformId;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<StartTransformRequest> {
        private String transformId;
        @Nullable
        private String timeout;

        public Builder transformId(String value) {
            this.transformId = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public StartTransformRequest build() {
            return new StartTransformRequest(this);
        }
    }
}

