/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.reindex.Destination;
import co.elastic.clients.elasticsearch.core.reindex.Source;
import co.elastic.clients.elasticsearch.transform.Latest;
import co.elastic.clients.elasticsearch.transform.Pivot;
import co.elastic.clients.elasticsearch.transform.PreviewTransformResponse;
import co.elastic.clients.elasticsearch.transform.RetentionPolicy;
import co.elastic.clients.elasticsearch.transform.Settings;
import co.elastic.clients.elasticsearch.transform.Sync;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PreviewTransformRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String transformId;
    @Nullable
    private final Destination dest;
    @Nullable
    private final String description;
    @Nullable
    private final String frequency;
    @Nullable
    private final Pivot pivot;
    @Nullable
    private final Source source;
    @Nullable
    private final Settings settings;
    @Nullable
    private final Sync sync;
    @Nullable
    private final RetentionPolicy retentionPolicy;
    @Nullable
    private final Latest latest;
    public static final JsonpDeserializer<PreviewTransformRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PreviewTransformRequest::setupPreviewTransformRequestDeserializer, Builder::build);
    private static final SimpleEndpoint<PreviewTransformRequest, Void> ENDPOINT = new SimpleEndpoint(request -> "POST", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (request.transformId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            buf.append("/_preview");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/_preview");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, null);

    public PreviewTransformRequest(AbstractBuilder<?> builder) {
        this.transformId = ((AbstractBuilder)builder).transformId;
        this.dest = ((AbstractBuilder)builder).dest;
        this.description = ((AbstractBuilder)builder).description;
        this.frequency = ((AbstractBuilder)builder).frequency;
        this.pivot = ((AbstractBuilder)builder).pivot;
        this.source = ((AbstractBuilder)builder).source;
        this.settings = ((AbstractBuilder)builder).settings;
        this.sync = ((AbstractBuilder)builder).sync;
        this.retentionPolicy = ((AbstractBuilder)builder).retentionPolicy;
        this.latest = ((AbstractBuilder)builder).latest;
    }

    @Nullable
    public String transformId() {
        return this.transformId;
    }

    @Nullable
    public Destination dest() {
        return this.dest;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public String frequency() {
        return this.frequency;
    }

    @Nullable
    public Pivot pivot() {
        return this.pivot;
    }

    @Nullable
    public Source source() {
        return this.source;
    }

    @Nullable
    public Settings settings() {
        return this.settings;
    }

    @Nullable
    public Sync sync() {
        return this.sync;
    }

    @Nullable
    public RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    @Nullable
    public Latest latest() {
        return this.latest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dest != null) {
            generator.writeKey("dest");
            this.dest.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.frequency != null) {
            generator.writeKey("frequency");
            generator.write(this.frequency);
        }
        if (this.pivot != null) {
            generator.writeKey("pivot");
            this.pivot.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (this.sync != null) {
            generator.writeKey("sync");
            this.sync.serialize(generator, mapper);
        }
        if (this.retentionPolicy != null) {
            generator.writeKey("retention_policy");
            this.retentionPolicy.serialize(generator, mapper);
        }
        if (this.latest != null) {
            generator.writeKey("latest");
            this.latest.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupPreviewTransformRequestDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::dest, Destination._DESERIALIZER, "dest", new String[0]);
        op.add(AbstractBuilder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(AbstractBuilder::frequency, JsonpDeserializer.stringDeserializer(), "frequency", new String[0]);
        op.add(AbstractBuilder::pivot, Pivot._DESERIALIZER, "pivot", new String[0]);
        op.add(AbstractBuilder::source, Source._DESERIALIZER, "source", new String[0]);
        op.add(AbstractBuilder::settings, Settings._DESERIALIZER, "settings", new String[0]);
        op.add(AbstractBuilder::sync, Sync._DESERIALIZER, "sync", new String[0]);
        op.add(AbstractBuilder::retentionPolicy, RetentionPolicy._DESERIALIZER, "retention_policy", new String[0]);
        op.add(AbstractBuilder::latest, Latest._DESERIALIZER, "latest", new String[0]);
    }

    public static <TTransform> Endpoint<PreviewTransformRequest, PreviewTransformResponse<TTransform>, ElasticsearchError> createPreviewTransformEndpoint(JsonpDeserializer<TTransform> tTransformDeserializer) {
        return ENDPOINT.withResponseDeserializer(PreviewTransformResponse.createPreviewTransformResponseDeserializer(tTransformDeserializer));
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private String transformId;
        @Nullable
        private Destination dest;
        @Nullable
        private String description;
        @Nullable
        private String frequency;
        @Nullable
        private Pivot pivot;
        @Nullable
        private Source source;
        @Nullable
        private Settings settings;
        @Nullable
        private Sync sync;
        @Nullable
        private RetentionPolicy retentionPolicy;
        @Nullable
        private Latest latest;

        protected AbstractBuilder() {
        }

        public BuilderT transformId(@Nullable String value) {
            this.transformId = value;
            return this.self();
        }

        public BuilderT dest(@Nullable Destination value) {
            this.dest = value;
            return this.self();
        }

        public BuilderT dest(Function<Destination.Builder, ObjectBuilder<Destination>> fn) {
            return this.dest(fn.apply(new Destination.Builder()).build());
        }

        public BuilderT description(@Nullable String value) {
            this.description = value;
            return this.self();
        }

        public BuilderT frequency(@Nullable String value) {
            this.frequency = value;
            return this.self();
        }

        public BuilderT pivot(@Nullable Pivot value) {
            this.pivot = value;
            return this.self();
        }

        public BuilderT pivot(Function<Pivot.Builder, ObjectBuilder<Pivot>> fn) {
            return this.pivot(fn.apply(new Pivot.Builder()).build());
        }

        public BuilderT source(@Nullable Source value) {
            this.source = value;
            return this.self();
        }

        public BuilderT source(Function<Source.Builder, ObjectBuilder<Source>> fn) {
            return this.source(fn.apply(new Source.Builder()).build());
        }

        public BuilderT settings(@Nullable Settings value) {
            this.settings = value;
            return this.self();
        }

        public BuilderT settings(Function<Settings.Builder, ObjectBuilder<Settings>> fn) {
            return this.settings(fn.apply(new Settings.Builder()).build());
        }

        public BuilderT sync(@Nullable Sync value) {
            this.sync = value;
            return this.self();
        }

        public BuilderT sync(Function<Sync.Builder, ObjectBuilder<Sync>> fn) {
            return this.sync(fn.apply(new Sync.Builder()).build());
        }

        public BuilderT retentionPolicy(@Nullable RetentionPolicy value) {
            this.retentionPolicy = value;
            return this.self();
        }

        public BuilderT retentionPolicy(Function<RetentionPolicy.Builder, ObjectBuilder<RetentionPolicy>> fn) {
            return this.retentionPolicy(fn.apply(new RetentionPolicy.Builder()).build());
        }

        public BuilderT latest(@Nullable Latest value) {
            this.latest = value;
            return this.self();
        }

        public BuilderT latest(Function<Latest.Builder, ObjectBuilder<Latest>> fn) {
            return this.latest(fn.apply(new Latest.Builder()).build());
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<PreviewTransformRequest> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PreviewTransformRequest build() {
            return new PreviewTransformRequest(this);
        }
    }
}

