/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.transform.GetTransformStatsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetTransformStatsRequest
extends RequestBase {
    private final String transformId;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Long from;
    @Nullable
    private final Long size;
    public static final Endpoint<GetTransformStatsRequest, GetTransformStatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetTransformStatsRequest, GetTransformStatsResponse>(request -> "GET", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTransformStatsResponse._DESERIALIZER);

    public GetTransformStatsRequest(Builder builder) {
        this.transformId = Objects.requireNonNull(builder.transformId, "transform_id");
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.size = builder.size;
    }

    public GetTransformStatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String transformId() {
        return this.transformId;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Long from() {
        return this.from;
    }

    @Nullable
    public Long size() {
        return this.size;
    }

    public static class Builder
    implements ObjectBuilder<GetTransformStatsRequest> {
        private String transformId;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Long from;
        @Nullable
        private Long size;

        public Builder transformId(String value) {
            this.transformId = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder from(@Nullable Long value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Long value) {
            this.size = value;
            return this;
        }

        @Override
        public GetTransformStatsRequest build() {
            return new GetTransformStatsRequest(this);
        }
    }
}

